/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.common.swagger.springdoc.conf;

import io.swagger.v3.oas.models.security.OAuthFlow;
import org.activiti.cloud.common.swagger.springdoc.BaseOpenApiBuilder;
import org.activiti.cloud.common.swagger.springdoc.customizer.CustomOperationIdCustomizer;
import org.activiti.cloud.common.swagger.springdoc.customizer.ErrorResponsesOperationCustomizer;
import org.activiti.cloud.common.swagger.springdoc.customizer.PathPrefixOpenApiCustomizer;
import org.activiti.cloud.common.swagger.springdoc.customizer.SchemaTitleOpenApiCustomizer;
import org.activiti.cloud.common.swagger.springdoc.customizer.SecurityItemOperationCustomizer;
import org.activiti.cloud.common.swagger.springdoc.customizer.SummaryOperationCustomizer;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.CollectionModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.EntityModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.IgnoredTypesModelConverter;
import org.activiti.cloud.common.swagger.springdoc.modelconverter.PagedModelConverter;
import org.springdoc.core.customizers.OperationIdCustomizer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@PropertySource(value={"classpath:swagger-config.properties"})
public class SwaggerAutoConfiguration {
    @Value(value="${activiti.cloud.swagger.base-path:/}")
    private String swaggerBasePath;

    @Bean
    @ConditionalOnMissingBean
    @DependsOn(value={"swaggerOAuthFlow"})
    public BaseOpenApiBuilder baseOpenApiBuilder(BuildProperties buildProperties, OAuthFlow swaggerOAuthFlow) {
        return new BaseOpenApiBuilder(buildProperties, swaggerOAuthFlow);
    }

    @Bean
    @ConditionalOnMissingBean
    public PathPrefixOpenApiCustomizer pathPrefixCustomizer() {
        return new PathPrefixOpenApiCustomizer(this.swaggerBasePath);
    }

    @Bean
    @ConditionalOnMissingBean
    public ErrorResponsesOperationCustomizer errorResponsesOperationCustomizer() {
        return new ErrorResponsesOperationCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SummaryOperationCustomizer summaryOperationCustomizer() {
        return new SummaryOperationCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SecurityItemOperationCustomizer securityItemOperationCustomizer() {
        return new SecurityItemOperationCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SchemaTitleOpenApiCustomizer schemaTitleOpenApiCustomizer() {
        return new SchemaTitleOpenApiCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public OperationIdCustomizer operationIdCustomizer() {
        return new CustomOperationIdCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public IgnoredTypesModelConverter ignoredTypesModelConverter() {
        return new IgnoredTypesModelConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public CollectionModelConverter collectionModelConverter() {
        return new CollectionModelConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityModelConverter entityModelConverter() {
        return new EntityModelConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public PagedModelConverter pagedModelConverter() {
        return new PagedModelConverter();
    }
}

