/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.test.asserts;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.activiti.cloud.services.common.file.FileContent;
import org.activiti.cloud.services.test.asserts.AssertZipContent;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AssertZipContentTest {
    AssertZipContentTest() {
    }

    private FileContent zipWithJsonEntry(String entryName, String json) throws IOException {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        try (ZipOutputStream zipOut = new ZipOutputStream(byteOut);){
            zipOut.putNextEntry(new ZipEntry(entryName));
            zipOut.write(json.getBytes(StandardCharsets.UTF_8));
            zipOut.closeEntry();
        }
        return new FileContent("test.zip", "application/zip", byteOut.toByteArray());
    }

    @Test
    void shouldValidateJsonEntry_basicCheck() throws IOException {
        FileContent fileContent = this.zipWithJsonEntry("data.json", "{\"foo\":\"bar\"}");
        AssertZipContent zipAssert = new AssertZipContent(fileContent);
        Assertions.assertThat((Object)fileContent).isNotNull();
        Assertions.assertThat((String)fileContent.getFilename()).isEqualTo("test.zip");
        Assertions.assertThat((String)fileContent.getContentType()).isEqualTo("application/zip");
        Assertions.assertThat((Object)zipAssert).isNotNull();
        zipAssert.hasEntries(new String[]{"data.json"});
        zipAssert.hasName("test.zip");
        zipAssert.hasJsonContent("data.json");
        zipAssert.hasContent("data.json", "{\"foo\":\"bar\"}");
    }

    @Test
    void shouldValidateJsonEntryWithAssertion() throws IOException {
        FileContent fileContent = this.zipWithJsonEntry("data.json", "{\"foo\":\"bar\"}");
        AssertZipContent zipAssert = new AssertZipContent(fileContent);
        zipAssert.hasJsonContentSatisfying("data.json", json -> json.node("foo").isEqualTo((Object)"bar"));
    }
}

