/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.connectors.starter.channels;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Optional;
import org.activiti.cloud.api.process.model.IntegrationError;
import org.activiti.cloud.api.process.model.IntegrationRequest;
import org.activiti.cloud.connectors.starter.channels.IntegrationErrorHandler;
import org.activiti.cloud.connectors.starter.channels.IntegrationErrorSender;
import org.activiti.cloud.connectors.starter.configuration.ConnectorProperties;
import org.activiti.cloud.connectors.starter.model.IntegrationErrorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.ErrorMessage;

public class IntegrationErrorHandlerImpl
implements IntegrationErrorHandler {
    private static final String INTEGRATION_CONTEXT_ID = "integrationContextId";
    private static Logger logger = LoggerFactory.getLogger(IntegrationErrorHandlerImpl.class);
    private final IntegrationErrorSender integrationErrorSender;
    private final ConnectorProperties connectorProperties;
    private final ObjectMapper objectMapper;

    public IntegrationErrorHandlerImpl(IntegrationErrorSender integrationErrorSender, ConnectorProperties connectorProperties, ObjectMapper objectMapper) {
        this.integrationErrorSender = integrationErrorSender;
        this.connectorProperties = connectorProperties;
        this.objectMapper = objectMapper;
    }

    @Override
    public void handleErrorMessage(ErrorMessage errorMessage) {
        Optional<Message> failedMessage;
        logger.debug("Error Message exception occurred: {}", (Object)errorMessage);
        MessagingException throwablePayload = (MessagingException)MessagingException.class.cast(errorMessage.getPayload());
        Optional<Message> originalMessage = Optional.ofNullable(errorMessage.getOriginalMessage());
        Optional<Message> optional = failedMessage = originalMessage.isPresent() ? originalMessage : Optional.ofNullable(throwablePayload.getFailedMessage());
        if (failedMessage.isPresent()) {
            failedMessage.filter(this::isIntegrationRequest).map(it -> new ErrorMessage((Throwable)throwablePayload, it)).ifPresent(this::sendIntegrationError);
        } else {
            logger.warn("The originalMessage is empty");
        }
    }

    private boolean isIntegrationRequest(Message<?> message) {
        return Optional.ofNullable(message).map(Message::getHeaders).map(headers -> headers.get((Object)INTEGRATION_CONTEXT_ID)).isPresent();
    }

    private void sendIntegrationError(ErrorMessage errorMessage) {
        byte[] data = (byte[])errorMessage.getOriginalMessage().getPayload();
        try {
            IntegrationRequest integrationRequest = (IntegrationRequest)this.objectMapper.readValue(data, IntegrationRequest.class);
            Throwable cause = Optional.ofNullable(((Throwable)errorMessage.getPayload()).getCause()).orElse((Throwable)errorMessage.getPayload());
            Message<IntegrationError> message = IntegrationErrorBuilder.errorFor(integrationRequest, this.connectorProperties, cause).buildMessage();
            this.integrationErrorSender.send(message);
        }
        catch (Throwable cause) {
            logger.error("Error sending IntegrationError for IntegrationRequest", cause);
        }
    }
}

