/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.api.process.model.builders;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.activiti.api.process.model.payloads.ReceiveMessagePayload;

public class ReceiveMessagePayloadBuilder {
    private String name;
    private String correlationKey;
    private Map<String, Object> variables;

    public static ReceiveMessagePayloadBuilder from(ReceiveMessagePayload messagePayload) {
        Objects.requireNonNull(messagePayload, "messagePayload must not be null");
        return new ReceiveMessagePayloadBuilder().withName(messagePayload.getName()).withCorrelationKey(messagePayload.getCorrelationKey()).withVariables(messagePayload.getVariables());
    }

    public static ReceiveMessagePayloadBuilder receive(String name) {
        return new ReceiveMessagePayloadBuilder().withName(name);
    }

    public ReceiveMessagePayloadBuilder withName(String name) {
        Objects.requireNonNull(name, "name must not be null");
        this.name = name;
        return this;
    }

    public ReceiveMessagePayloadBuilder withVariables(Map<String, Object> variables) {
        this.variables = variables;
        return this;
    }

    public ReceiveMessagePayloadBuilder withVariable(String name, Object value) {
        if (this.variables == null) {
            this.variables = new LinkedHashMap<String, Object>();
        }
        this.variables.put(name, value);
        return this;
    }

    public ReceiveMessagePayloadBuilder withCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    public ReceiveMessagePayload build() {
        return new ReceiveMessagePayload(this.name, this.correlationKey, this.variables);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReceiveMessagePayloadBuilder [name=");
        builder.append(this.name);
        builder.append(", correlationKey=");
        builder.append(this.correlationKey);
        builder.append(", variables=");
        builder.append(this.variables);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.correlationKey, this.name, this.variables);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReceiveMessagePayloadBuilder other = (ReceiveMessagePayloadBuilder)obj;
        return Objects.equals(this.correlationKey, other.correlationKey) && Objects.equals(this.name, other.name) && Objects.equals(this.variables, other.variables);
    }
}

