/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.conf;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.activiti.core.el.CustomFunctionProvider;
import org.activiti.engine.impl.bpmn.behavior.VariablesCalculator;
import org.activiti.engine.impl.bpmn.behavior.VariablesPropagator;
import org.activiti.engine.impl.delegate.invocation.DefaultDelegateInterceptor;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.interceptor.DelegateInterceptor;
import org.activiti.runtime.api.connector.DefaultServiceTaskBehavior;
import org.activiti.runtime.api.connector.IntegrationContextBuilder;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.ExtensionsVariablesMappingProvider;
import org.activiti.spring.process.ProcessExtensionService;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
public class ConnectorsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ExpressionManager expressionManager(List<CustomFunctionProvider> customFunctionProviders) {
        ExpressionManager expressionManager = new ExpressionManager();
        expressionManager.setCustomFunctionProviders(customFunctionProviders);
        return expressionManager;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExpressionResolver expressionResolver(ExpressionManager expressionManager, ObjectMapper objectMapper) {
        return new ExpressionResolver(expressionManager, objectMapper, (DelegateInterceptor)new DefaultDelegateInterceptor());
    }

    @Bean
    @ConditionalOnMissingBean
    public IntegrationContextBuilder integrationContextBuilder(ExtensionsVariablesMappingProvider variablesMappingProvider, ExpressionManager expressionManager) {
        return new IntegrationContextBuilder(variablesMappingProvider, expressionManager);
    }

    @Bean(name={"defaultServiceTaskBehavior"})
    @ConditionalOnMissingBean(name={"defaultServiceTaskBehavior"})
    public DefaultServiceTaskBehavior defaultServiceTaskBehavior(ApplicationContext applicationContext, IntegrationContextBuilder integrationContextBuilder, VariablesPropagator variablesPropagator) {
        return new DefaultServiceTaskBehavior(applicationContext, integrationContextBuilder, variablesPropagator);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExtensionsVariablesMappingProvider variablesMappingProvider(ProcessExtensionService processExtensionService, ExpressionResolver expressionResolver) {
        return new ExtensionsVariablesMappingProvider(processExtensionService, expressionResolver);
    }

    @Bean
    @ConditionalOnMissingBean
    public VariablesPropagator variablesPropagator(VariablesCalculator variablesCalculator) {
        return new VariablesPropagator(variablesCalculator);
    }
}

