/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.impl;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.JsonPatch;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.MappingExecutionContext;
import org.activiti.engine.impl.bpmn.behavior.VariablesCalculator;
import org.activiti.engine.impl.persistence.entity.VariableInstance;
import org.activiti.runtime.api.impl.CompositeVariableExpressionEvaluator;
import org.activiti.runtime.api.impl.ExpressionResolver;
import org.activiti.runtime.api.impl.SimpleMapExpressionEvaluator;
import org.activiti.runtime.api.impl.VariableScopeExpressionEvaluator;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.ConstantDefinition;
import org.activiti.spring.process.model.Extension;
import org.activiti.spring.process.model.Mapping;
import org.activiti.spring.process.model.ProcessConstantsMapping;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;
import org.activiti.spring.process.variable.VariableParsingService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsVariablesMappingProvider
implements VariablesCalculator {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionsVariablesMappingProvider.class);
    private ProcessExtensionService processExtensionService;
    private ExpressionResolver expressionResolver;
    private VariableParsingService variableParsingService;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("/\\$\\{(\\w+)}");
    public static final String JSON_PATCH_MAPPING_ERROR = "Invalid jsonPatch variable mapping";

    public ExtensionsVariablesMappingProvider(ProcessExtensionService processExtensionService, ExpressionResolver expressionResolver, VariableParsingService variableParsingService) {
        this.processExtensionService = processExtensionService;
        this.expressionResolver = expressionResolver;
        this.variableParsingService = variableParsingService;
    }

    protected Optional<Object> calculateMappedValue(Mapping inputMapping, DelegateExecution execution, Extension extensions) {
        if (inputMapping != null) {
            String name;
            if (Mapping.SourceMappingType.VALUE.equals((Object)inputMapping.getType())) {
                return Optional.of(inputMapping.getValue());
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)inputMapping.getType()) && this.isTargetProcessVariableDefined(extensions, execution, name = inputMapping.getValue().toString())) {
                return Optional.ofNullable(execution.getVariable(name));
            }
        }
        return Optional.empty();
    }

    public Map<String, Object> calculateInputVariables(DelegateExecution execution) {
        Extension extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        Map<String, Object> constants = this.calculateConstants(execution, extensions);
        if (!extensions.hasMapping(execution.getCurrentActivityId())) {
            return constants;
        }
        if (extensions.shouldMapAllInputs(execution.getCurrentActivityId())) {
            HashMap<String, Object> variables = new HashMap<String, Object>(constants);
            variables.putAll(execution.getVariables());
            return variables;
        }
        Map<String, Object> inboundVariables = this.calculateInputVariables(execution, extensions);
        inboundVariables = this.expressionResolver.resolveExpressionsMap(new VariableScopeExpressionEvaluator((VariableScope)execution), inboundVariables);
        inboundVariables.putAll(constants);
        return inboundVariables;
    }

    public boolean isMappingEphemeral(DelegateExecution execution) {
        Extension extension = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        return extension != null && extension.getMappings() != null && extension.getMappings().get(execution.getCurrentActivityId()) != null && ((ProcessVariablesMapping)extension.getMappings().get(execution.getCurrentActivityId())).isEphemeral();
    }

    private Map<String, Object> calculateConstants(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> constants = new HashMap<String, Object>();
        ProcessConstantsMapping processConstantsMapping = extensions.getConstantForFlowElement(execution.getCurrentActivityId());
        for (Map.Entry mapping : processConstantsMapping.entrySet()) {
            constants.put((String)mapping.getKey(), ((ConstantDefinition)mapping.getValue()).getValue());
        }
        return constants;
    }

    private Map<String, Object> calculateInputVariables(DelegateExecution execution, Extension extensions) {
        HashMap<String, Object> inboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(execution.getCurrentActivityId());
        Map inputMappings = processVariablesMapping.getInputs();
        for (Map.Entry mapping : inputMappings.entrySet()) {
            Optional<Object> mappedValue = this.calculateMappedValue((Mapping)mapping.getValue(), execution, extensions);
            mappedValue.ifPresent(value -> inboundVariables.put((String)mapping.getKey(), value));
        }
        return inboundVariables;
    }

    private Optional<Object> calculateOutPutMappedValue(Map.Entry<String, Mapping> mappingEntry, Map<String, Object> currentContextVariables, DelegateExecution execution, Extension extensions) {
        Mapping mapping = mappingEntry.getValue();
        if (mapping == null || mapping.getType() == null) {
            return Optional.empty();
        }
        switch (mapping.getType()) {
            case VALUE: {
                return Optional.of(mapping.getValue());
            }
            case JSONPATCH: {
                return this.resolvePatchMapping(mappingEntry.getKey(), mapping.getValue(), execution, extensions);
            }
            case VARIABLE: {
                if (currentContextVariables == null) break;
                return Optional.ofNullable(currentContextVariables.get(mapping.getValue().toString()));
            }
        }
        return Optional.empty();
    }

    private Optional<Object> resolvePatchMapping(String outputVariableName, Object changesToApply, DelegateExecution execution, Extension extensions) {
        Object executionVariableValue = execution != null ? execution.getVariable(outputVariableName) : null;
        Object processVariableCurrentValue = this.calculateProcessVariableCurrentValue(executionVariableValue, extensions.getPropertyByName(outputVariableName));
        try {
            Object oldNode = this.isObjectVariable(processVariableCurrentValue) ? (JsonNode)objectMapper.convertValue(processVariableCurrentValue, JsonNode.class) : objectMapper.createObjectNode();
            JsonNode patchNode = (JsonNode)objectMapper.convertValue(changesToApply, JsonNode.class);
            this.replaceVariablesInJsonPath(patchNode, execution, extensions);
            this.initializePath((JsonNode)oldNode, patchNode);
            JsonNode patchedNode = JsonPatch.apply((JsonNode)patchNode, (JsonNode)oldNode);
            return Optional.ofNullable(objectMapper.treeToValue((TreeNode)patchedNode, Object.class));
        }
        catch (Exception e) {
            LOGGER.error("Error patching variable. Changes to apply: {}, Process variable current value: {}", new Object[]{changesToApply, processVariableCurrentValue, e});
            throw new ActivitiIllegalArgumentException(JSON_PATCH_MAPPING_ERROR, (Throwable)e);
        }
    }

    private boolean isObjectVariable(Object variable) {
        return variable instanceof ObjectNode || variable instanceof Map;
    }

    private void replaceVariablesInJsonPath(JsonNode patchNode, DelegateExecution execution, Extension extensions) {
        for (JsonNode patch : patchNode) {
            String updatedPath;
            String path;
            if (!patch.has("path") || (path = patch.get("path").asText()).equals(updatedPath = this.resolvePath(path, execution, extensions)) || !(patch instanceof ObjectNode)) continue;
            ((ObjectNode)patch).put("path", updatedPath);
        }
    }

    private String resolvePath(String path, DelegateExecution execution, Extension extensions) {
        Matcher matcher = VARIABLE_PATTERN.matcher(path);
        StringBuilder updatedPath = new StringBuilder();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            String replacedValue = this.replacePathVariables(variableName, execution, extensions);
            matcher.appendReplacement(updatedPath, "/" + replacedValue);
        }
        matcher.appendTail(updatedPath);
        return updatedPath.toString();
    }

    private String replacePathVariables(String variableName, DelegateExecution execution, Extension extensions) {
        VariableInstance variableInstance;
        if (!this.isTargetProcessVariableDefined(extensions, execution, variableName)) {
            throw new ActivitiIllegalArgumentException(String.format("Path variable $%s used in JsonPatch mapping is not defined for the current process", variableName));
        }
        VariableInstance variableInstance2 = variableInstance = execution != null ? execution.getVariableInstance(variableName) : null;
        if (variableInstance != null) {
            return this.replaceVariableIfSupported(variableInstance.getValue(), variableInstance.getTypeName(), variableName);
        }
        VariableDefinition propertyObj = extensions.getPropertyByName(variableName);
        return this.replaceVariableIfSupported(propertyObj.getValue(), propertyObj.getType(), variableName);
    }

    private String replaceVariableIfSupported(Object value, String type, String originalProperty) {
        if (value == null || StringUtils.isBlank((CharSequence)value.toString())) {
            throw new ActivitiIllegalArgumentException(String.format("Path variable $%s used in JsonPatch mapping should not be empty", originalProperty));
        }
        String typeLowerCase = type.toLowerCase();
        if ("string".equals(typeLowerCase) || "integer".equals(typeLowerCase)) {
            return value.toString();
        }
        throw new ActivitiIllegalArgumentException(String.format("Variable %s of type '%s' is not allowed in JsonPatch mapping. Only string and integer types are allowed", originalProperty, type));
    }

    private void initializePath(JsonNode oldNode, JsonNode patchNode) {
        for (JsonNode patch : patchNode) {
            String path = patch.get("path").asText();
            String[] properties = path.split("/");
            JsonNode currentNode = oldNode;
            for (int i = 1; i < properties.length; ++i) {
                String property = properties[i];
                if (this.isArrayElementPath(i, properties, property)) {
                    this.prepareArrayElementForReplace((ObjectNode)patch, currentNode, property);
                    continue;
                }
                if (this.isArrayProperty(currentNode, property)) {
                    currentNode = this.handleArrayPath(property, currentNode);
                    continue;
                }
                if (!currentNode.has(property) || !currentNode.get(property).isObject()) {
                    ((ObjectNode)currentNode).set(property, (JsonNode)objectMapper.createObjectNode());
                }
                currentNode = currentNode.get(property);
            }
        }
    }

    private boolean isArrayProperty(JsonNode node, String property) {
        return node.isArray() || !node.isEmpty() && node.has(property) && node.get(property).isArray() || property.matches("\\d+");
    }

    private void prepareArrayElementForReplace(ObjectNode patch, JsonNode currentNode, String property) {
        if (currentNode.isArray()) {
            patch.put("op", "replace");
            ArrayNode arrayNode = (ArrayNode)currentNode;
            int index = Integer.parseInt(property);
            while (arrayNode.size() <= index) {
                arrayNode.add((JsonNode)objectMapper.createObjectNode());
            }
        }
    }

    private boolean isArrayElementPath(int index, String[] properties, String property) {
        return index == properties.length - 1 && StringUtils.isNumeric((CharSequence)property);
    }

    private JsonNode handleArrayPath(String property, JsonNode currentNode) {
        if (!currentNode.isArray()) {
            return currentNode.get(property);
        }
        int index = Integer.parseInt(property);
        ArrayNode arrayNode = (ArrayNode)currentNode;
        while (arrayNode.size() <= index) {
            arrayNode.add((JsonNode)objectMapper.createObjectNode());
        }
        return arrayNode.get(index);
    }

    public Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables) {
        Extension extensions = this.processExtensionService.getExtensionsForId(mappingExecutionContext.getProcessDefinitionId());
        if (!extensions.hasMapping(mappingExecutionContext.getActivityId())) {
            return Collections.emptyMap();
        }
        if (this.expressionResolver.containsExpression(availableVariables)) {
            throw new ActivitiIllegalArgumentException("Expressions are not allowed as variable values in the output mapping");
        }
        if (extensions.shouldMapAllOutputs(mappingExecutionContext.getActivityId())) {
            return availableVariables != null ? new HashMap<String, Object>(availableVariables) : Collections.emptyMap();
        }
        return this.calculateOutPutVariables(mappingExecutionContext, extensions, availableVariables);
    }

    private Map<String, Object> calculateOutPutVariables(MappingExecutionContext mappingExecutionContext, Extension extensions, Map<String, Object> availableVariables) {
        HashMap<String, Object> outboundVariables = new HashMap<String, Object>();
        ProcessVariablesMapping processVariablesMapping = extensions.getMappingForFlowElement(mappingExecutionContext.getActivityId());
        Map outputMappings = processVariablesMapping.getOutputs();
        DelegateExecution execution = mappingExecutionContext.getExecution();
        for (Map.Entry<String, Mapping> entry : outputMappings.entrySet()) {
            String name = (String)entry.getKey();
            if (!this.isTargetProcessVariableDefined(extensions, execution, name)) continue;
            this.calculateOutPutMappedValue(entry, availableVariables, execution, extensions).ifPresent(value -> extensions.getProperties().values().stream().filter(v -> v.getName().equals(name)).findAny().ifPresentOrElse(v -> outboundVariables.put(name, this.variableParsingService.parse(new VariableDefinition(v.getType(), value))), () -> outboundVariables.put(name, value)));
        }
        return this.resolveExpressions(mappingExecutionContext, availableVariables, outboundVariables);
    }

    private Object calculateProcessVariableCurrentValue(Object executionVariableValue, VariableDefinition propertyVariableDefinition) {
        return !this.isProcessVariableNull(executionVariableValue) ? executionVariableValue : propertyVariableDefinition.getValue();
    }

    private boolean isProcessVariableNull(Object variable) {
        return variable == null || NullNode.getInstance().equals(variable);
    }

    private Map<String, Object> resolveExpressions(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables, Map<String, Object> outboundVariables) {
        if (mappingExecutionContext.hasExecution()) {
            return this.resolveExecutionExpressions(mappingExecutionContext, availableVariables, outboundVariables);
        }
        return this.expressionResolver.resolveExpressionsMap(new SimpleMapExpressionEvaluator(availableVariables), outboundVariables);
    }

    private Map<String, Object> resolveExecutionExpressions(MappingExecutionContext mappingExecutionContext, Map<String, Object> availableVariables, Map<String, Object> outboundVariables) {
        if (availableVariables != null && !availableVariables.isEmpty()) {
            return this.expressionResolver.resolveExpressionsMap(new CompositeVariableExpressionEvaluator(new SimpleMapExpressionEvaluator(availableVariables), new VariableScopeExpressionEvaluator((VariableScope)mappingExecutionContext.getExecution())), outboundVariables);
        }
        return this.expressionResolver.resolveExpressionsMap(new VariableScopeExpressionEvaluator((VariableScope)mappingExecutionContext.getExecution()), outboundVariables);
    }

    private boolean isTargetProcessVariableDefined(Extension extensions, DelegateExecution execution, String variableName) {
        return extensions.getPropertyByName(variableName) != null || execution != null && execution.getVariable(variableName) != null;
    }
}

