/*
 * Copyright 2010-2020 Alfresco Software, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.activiti.runtime.api.query.impl;

import org.activiti.api.runtime.shared.query.Page;

import java.util.List;

public class PageImpl<T> implements Page<T> {

    private List<T> content;
    private int totalItems;

    public PageImpl(List<T> content,
                    int totalItems) {
        this.content = content;
        this.totalItems = totalItems;
    }

    @Override
    public List<T> getContent() {
        return content;
    }

    @Override
    public int getTotalItems() {
        return totalItems;
    }
}
