/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.behavior;

import java.util.List;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.impl.asyncexecutor.JobManager;
import org.activiti.engine.impl.bpmn.behavior.IntermediateCatchEventActivityBehavior;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.jobexecutor.TimerEventHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntityManager;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;

public class IntermediateCatchTimerEventActivityBehavior
extends IntermediateCatchEventActivityBehavior {
    private static final long serialVersionUID = 1L;
    protected TimerEventDefinition timerEventDefinition;

    public IntermediateCatchTimerEventActivityBehavior(TimerEventDefinition timerEventDefinition) {
        this.timerEventDefinition = timerEventDefinition;
    }

    @Override
    public void execute(DelegateExecution execution) {
        JobManager jobManager = Context.getCommandContext().getJobManager();
        TimerJobEntity timerJob = jobManager.createTimerJob(this.timerEventDefinition, false, (ExecutionEntity)execution, "trigger-timer", TimerEventHandler.createConfiguration(execution.getCurrentActivityId(), null, this.timerEventDefinition.getCalendarName()));
        if (timerJob != null) {
            jobManager.scheduleTimerJob(timerJob);
        }
    }

    @Override
    public void eventCancelledByEventGateway(DelegateExecution execution) {
        JobEntityManager jobEntityManager = Context.getCommandContext().getJobEntityManager();
        List<JobEntity> jobEntities = jobEntityManager.findJobsByExecutionId(execution.getId());
        for (JobEntity jobEntity : jobEntities) {
            jobEntityManager.delete(jobEntity);
        }
        Context.getCommandContext().getExecutionEntityManager().deleteExecutionAndRelatedData((ExecutionEntity)execution, "event based gateway cancel");
    }
}

