/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import java.util.Optional;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.activiti.engine.impl.persistence.entity.DeploymentEntityManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

public class NewTaskCmd
implements Command<Task>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String taskId;

    public NewTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public Task execute(CommandContext commandContext) {
        TaskEntity task = (TaskEntity)commandContext.getTaskEntityManager().create();
        task.setId(this.taskId);
        task.setRevision(0);
        this.findAppVersionFromDeployment(commandContext.getDeploymentEntityManager()).ifPresent(task::setAppVersion);
        return task;
    }

    private Optional<Integer> findAppVersionFromDeployment(DeploymentEntityManager deploymentEntityManager) {
        DeploymentEntity deployment = deploymentEntityManager.findLatestDeploymentByName("SpringAutoDeployment");
        return Optional.ofNullable(deployment).map(DeploymentEntity::getVersion);
    }
}

