/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.List;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.impl.bpmn.helper.BaseDelegateEventListener;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.activiti.engine.impl.persistence.entity.EventSubscriptionEntityManager;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;

public class MessageThrowingEventListener
extends BaseDelegateEventListener {
    protected String messageName;
    protected Class<?> entityClass;

    @Override
    public void onEvent(ActivitiEvent event) {
        if (this.isValidEvent(event)) {
            if (event.getProcessInstanceId() == null) {
                throw new ActivitiIllegalArgumentException("Cannot throw process-instance scoped message, since the dispatched event is not part of an ongoing process instance");
            }
            EventSubscriptionEntityManager eventSubscriptionEntityManager = Context.getCommandContext().getEventSubscriptionEntityManager();
            List<MessageEventSubscriptionEntity> subscriptionEntities = eventSubscriptionEntityManager.findMessageEventSubscriptionsByProcessInstanceAndEventName(event.getProcessInstanceId(), this.messageName);
            for (EventSubscriptionEntity eventSubscriptionEntity : subscriptionEntities) {
                eventSubscriptionEntityManager.eventReceived(eventSubscriptionEntity, null, false);
            }
        }
    }

    public void setMessageName(String messageName) {
        this.messageName = messageName;
    }

    @Override
    public boolean isFailOnException() {
        return true;
    }
}

