/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.MultiInstanceLoopCharacteristics;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractFlowNodeBpmnParseHandler;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.el.ExpressionManager;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractActivityBpmnParseHandler<T extends FlowNode>
extends AbstractFlowNodeBpmnParseHandler<T> {
    @Override
    public void parse(BpmnParse bpmnParse, BaseElement element) {
        super.parse(bpmnParse, element);
        if (element instanceof Activity && ((Activity)element).getLoopCharacteristics() != null) {
            this.createMultiInstanceLoopCharacteristics(bpmnParse, (Activity)element);
        }
    }

    protected void createMultiInstanceLoopCharacteristics(BpmnParse bpmnParse, Activity modelActivity) {
        MultiInstanceLoopCharacteristics loopCharacteristics = modelActivity.getLoopCharacteristics();
        MultiInstanceActivityBehavior miActivityBehavior = this.createMultiInstanceActivityBehavior(bpmnParse, modelActivity, loopCharacteristics);
        modelActivity.setBehavior((Object)miActivityBehavior);
        ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getLoopCardinality())) {
            miActivityBehavior.setLoopCardinalityExpression(expressionManager.createExpression(loopCharacteristics.getLoopCardinality()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getCompletionCondition())) {
            miActivityBehavior.setCompletionConditionExpression(expressionManager.createExpression(loopCharacteristics.getCompletionCondition()));
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getInputDataItem())) {
            if (loopCharacteristics.getInputDataItem().contains("{")) {
                miActivityBehavior.setCollectionExpression(expressionManager.createExpression(loopCharacteristics.getInputDataItem()));
            } else {
                miActivityBehavior.setCollectionVariable(loopCharacteristics.getInputDataItem());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementVariable())) {
            miActivityBehavior.setCollectionElementVariable(loopCharacteristics.getElementVariable());
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getElementIndexVariable())) {
            miActivityBehavior.setCollectionElementIndexVariable(loopCharacteristics.getElementIndexVariable());
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getLoopDataOutputRef())) {
            miActivityBehavior.setLoopDataOutputRef(loopCharacteristics.getLoopDataOutputRef());
        }
        if (StringUtils.isNotEmpty((CharSequence)loopCharacteristics.getOutputDataItem())) {
            miActivityBehavior.setOutputDataItem(loopCharacteristics.getOutputDataItem());
        }
    }

    private MultiInstanceActivityBehavior createMultiInstanceActivityBehavior(BpmnParse bpmnParse, Activity modelActivity, MultiInstanceLoopCharacteristics loopCharacteristics) {
        MultiInstanceActivityBehavior miActivityBehavior = null;
        miActivityBehavior = loopCharacteristics.isSequential() ? bpmnParse.getActivityBehaviorFactory().createSequentialMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior()) : bpmnParse.getActivityBehaviorFactory().createParallelMultiInstanceBehavior(modelActivity, (AbstractBpmnActivityBehavior)modelActivity.getBehavior());
        return miActivityBehavior;
    }
}

