/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.test;

import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.impl.test.AbstractActivitiTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceActivitiTestCase
extends AbstractActivitiTestCase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceActivitiTestCase.class);
    protected String activitiConfigurationResource;
    protected String processEngineName;

    public ResourceActivitiTestCase(String activitiConfigurationResource) {
        this(activitiConfigurationResource, null);
    }

    public ResourceActivitiTestCase(String activitiConfigurationResource, String processEngineName) {
        this.activitiConfigurationResource = activitiConfigurationResource;
        this.processEngineName = processEngineName;
    }

    @Override
    protected void closeDownProcessEngine() {
        super.closeDownProcessEngine();
        ProcessEngines.unregister(this.processEngine);
        this.processEngine = null;
    }

    @Override
    protected void initializeProcessEngine() {
        ProcessEngineConfiguration config = ProcessEngineConfiguration.createProcessEngineConfigurationFromResource(this.activitiConfigurationResource);
        if (this.processEngineName != null) {
            logger.info("Initializing process engine with name '" + this.processEngineName + "'");
            config.setProcessEngineName(this.processEngineName);
        }
        this.additionalConfiguration(config);
        this.processEngine = config.buildProcessEngine();
    }

    protected void additionalConfiguration(ProcessEngineConfiguration processEngineConfiguration) {
    }
}

