/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.variable.EntityMetaData;

public class JPAEntityScanner {
    public EntityMetaData scanClass(Class<?> clazz) {
        EntityMetaData metaData = new EntityMetaData();
        while (clazz != null && !clazz.equals(Object.class)) {
            boolean isEntity = this.isEntityAnnotationPresent(clazz);
            if (isEntity) {
                metaData.setEntityClass(clazz);
                metaData.setJPAEntity(true);
                Field idField = this.getIdField(clazz);
                if (idField != null) {
                    metaData.setIdField(idField);
                    break;
                }
                Method idMethod = this.getIdMethod(clazz);
                if (idMethod != null) {
                    metaData.setIdMethod(idMethod);
                    break;
                }
                throw new ActivitiException("Cannot find field or method with annotation @Id on class '" + clazz.getName() + "', only single-valued primary keys are supported on JPA-entities");
            }
            clazz = clazz.getSuperclass();
        }
        return metaData;
    }

    private Method getIdMethod(Class<?> clazz) {
        Method idMethod = null;
        Method[] methods = clazz.getMethods();
        Id idAnnotation = null;
        for (Method method : methods) {
            idAnnotation = method.getAnnotation(Id.class);
            if (idAnnotation == null || method.isBridge()) continue;
            idMethod = method;
            break;
        }
        return idMethod;
    }

    private Field getIdField(Class<?> clazz) {
        Class<?> superClass;
        Field idField = null;
        Field[] fields = clazz.getDeclaredFields();
        Id idAnnotation = null;
        for (Field field : fields) {
            idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation == null) continue;
            idField = field;
            break;
        }
        if (idField == null && (superClass = clazz.getSuperclass()) != null && !superClass.equals(Object.class)) {
            idField = this.getIdField(superClass);
        }
        return idField;
    }

    private boolean isEntityAnnotationPresent(Class<?> clazz) {
        return clazz.getAnnotation(Entity.class) != null;
    }
}

