/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history;

import java.util.Date;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.delegate.event.ActivitiEventDispatcher;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.history.HistoryLevel;
import org.activiti.engine.impl.history.HistoryManager;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.cache.EntityCache;
import org.activiti.engine.impl.persistence.entity.CommentEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.activiti.engine.impl.persistence.entity.HistoricIdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHistoryManager
extends AbstractManager
implements HistoryManager {
    private static Logger log = LoggerFactory.getLogger((String)DefaultHistoryManager.class.getName());
    private HistoryLevel historyLevel;

    public DefaultHistoryManager(ProcessEngineConfigurationImpl processEngineConfiguration, HistoryLevel historyLevel) {
        super(processEngineConfiguration);
        this.historyLevel = historyLevel;
    }

    @Override
    public boolean isHistoryLevelAtLeast(HistoryLevel level) {
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}, level required: {}", (Object)this.historyLevel, (Object)level);
        }
        return this.historyLevel.isAtLeast(level);
    }

    @Override
    public boolean isHistoryEnabled() {
        if (log.isDebugEnabled()) {
            log.debug("Current history level: {}", (Object)this.historyLevel);
        }
        return !this.historyLevel.equals((Object)HistoryLevel.NONE);
    }

    @Override
    public void recordProcessInstanceEnd(String processInstanceId, String deleteReason, String activityId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.markEnded(deleteReason);
            historicProcessInstance.setEndActivityId(activityId);
            ActivitiEventDispatcher activitiEventDispatcher = this.getEventDispatcher();
            if (activitiEventDispatcher != null && activitiEventDispatcher.isEnabled()) {
                activitiEventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_ENDED, historicProcessInstance));
            }
        }
    }

    @Override
    public void recordProcessInstanceNameChange(String processInstanceId, String newName) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setName(newName);
        }
    }

    @Override
    public void recordProcessInstanceStart(ExecutionEntity processInstance, FlowElement startElement) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(processInstance);
            historicProcessInstance.setStartActivityId(startElement.getId());
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
            ActivitiEventDispatcher activitiEventDispatcher = this.getEventDispatcher();
            if (activitiEventDispatcher != null && activitiEventDispatcher.isEnabled()) {
                activitiEventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
        }
    }

    @Override
    public void recordSubProcessInstanceStart(ExecutionEntity parentExecution, ExecutionEntity subProcessInstance, FlowElement initialElement) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricActivityInstanceEntity activitiyInstance;
            HistoricProcessInstanceEntity historicProcessInstance = this.getHistoricProcessInstanceEntityManager().create(subProcessInstance);
            if (historicProcessInstance.getStartActivityId() == null) {
                historicProcessInstance.setStartActivityId(initialElement.getId());
            }
            this.getHistoricProcessInstanceEntityManager().insert(historicProcessInstance, false);
            ActivitiEventDispatcher activitiEventDispatcher = this.getEventDispatcher();
            if (activitiEventDispatcher != null && activitiEventDispatcher.isEnabled()) {
                activitiEventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_PROCESS_INSTANCE_CREATED, historicProcessInstance));
            }
            if ((activitiyInstance = this.findActivityInstance(parentExecution, false, true)) != null) {
                activitiyInstance.setCalledProcessInstanceId(subProcessInstance.getProcessInstanceId());
            }
        }
    }

    @Override
    public void recordActivityStart(ExecutionEntity executionEntity) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity.getActivityId() != null && executionEntity.getCurrentFlowElement() != null) {
            HistoricActivityInstanceEntity historicActivityInstanceEntity = null;
            HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionEntity.getId(), executionEntity.getActivityId(), true);
            historicActivityInstanceEntity = historicActivityInstanceEntityFromCache != null ? historicActivityInstanceEntityFromCache : this.createHistoricActivityInstanceEntity(executionEntity);
            ActivitiEventDispatcher activitiEventDispatcher = this.getEventDispatcher();
            if (activitiEventDispatcher != null && activitiEventDispatcher.isEnabled()) {
                activitiEventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_CREATED, historicActivityInstanceEntity));
            }
        }
    }

    @Override
    public void recordActivityEnd(ExecutionEntity executionEntity, String deleteReason) {
        HistoricActivityInstanceEntity historicActivityInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicActivityInstance = this.findActivityInstance(executionEntity, false, true)) != null) {
            historicActivityInstance.markEnded(deleteReason);
            ActivitiEventDispatcher activitiEventDispatcher = this.getEventDispatcher();
            if (activitiEventDispatcher != null && activitiEventDispatcher.isEnabled()) {
                activitiEventDispatcher.dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.HISTORIC_ACTIVITY_INSTANCE_ENDED, historicActivityInstance));
            }
        }
    }

    @Override
    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, boolean createOnNotFound, boolean endTimeMustBeNull) {
        String activityId = null;
        if (execution.getCurrentFlowElement() instanceof FlowNode) {
            activityId = execution.getCurrentFlowElement().getId();
        } else if (execution.getCurrentFlowElement() instanceof SequenceFlow && execution.getCurrentActivitiListener() == null) {
            activityId = ((SequenceFlow)execution.getCurrentFlowElement()).getSourceFlowElement().getId();
        }
        if (activityId != null) {
            return this.findActivityInstance(execution, activityId, createOnNotFound, endTimeMustBeNull);
        }
        return null;
    }

    public HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution, String activityId, boolean createOnNotFound, boolean endTimeMustBeNull) {
        HistoricActivityInstanceEntity historicActivityInstanceFromParent;
        List<HistoricActivityInstanceEntity> historicActivityInstances;
        if (activityId == null) {
            return null;
        }
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstanceEntityFromCache = this.getHistoricActivityInstanceFromCache(executionId, activityId, endTimeMustBeNull);
        if (historicActivityInstanceEntityFromCache != null) {
            return historicActivityInstanceEntityFromCache;
        }
        if (!execution.isInserted() && !execution.isProcessInstanceType() && (historicActivityInstances = this.getHistoricActivityInstanceEntityManager().findUnfinishedHistoricActivityInstancesByExecutionAndActivityId(executionId, activityId)).size() > 0) {
            return historicActivityInstances.getFirst();
        }
        if (execution.getParentId() != null && (historicActivityInstanceFromParent = this.findActivityInstance(execution.getParent(), activityId, false, endTimeMustBeNull)) != null) {
            return historicActivityInstanceFromParent;
        }
        if (createOnNotFound && activityId != null && (execution.getCurrentFlowElement() != null && execution.getCurrentFlowElement() instanceof FlowNode || execution.getCurrentFlowElement() == null)) {
            return this.createHistoricActivityInstanceEntity(execution);
        }
        return null;
    }

    protected HistoricActivityInstanceEntity getHistoricActivityInstanceFromCache(String executionId, String activityId, boolean endTimeMustBeNull) {
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = this.getEntityCache().findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || endTimeMustBeNull && cachedHistoricActivityInstance.getEndTime() != null || !executionId.equals(cachedHistoricActivityInstance.getExecutionId())) continue;
            return cachedHistoricActivityInstance;
        }
        return null;
    }

    protected HistoricActivityInstanceEntity createHistoricActivityInstanceEntity(ExecutionEntity execution) {
        IdGenerator idGenerator = this.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        HistoricActivityInstanceEntity historicActivityInstance = (HistoricActivityInstanceEntity)this.getHistoricActivityInstanceEntityManager().create();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInstanceId);
        historicActivityInstance.setExecutionId(execution.getId());
        historicActivityInstance.setActivityId(execution.getActivityId());
        if (execution.getCurrentFlowElement() != null) {
            historicActivityInstance.setActivityName(execution.getCurrentFlowElement().getName());
            historicActivityInstance.setActivityType(this.parseActivityType(execution.getCurrentFlowElement()));
        }
        Date now = this.getClock().getCurrentTime();
        historicActivityInstance.setStartTime(now);
        if (execution.getTenantId() != null) {
            historicActivityInstance.setTenantId(execution.getTenantId());
        }
        this.getHistoricActivityInstanceEntityManager().insert(historicActivityInstance);
        return historicActivityInstance;
    }

    @Override
    public void recordProcessDefinitionChange(String processInstanceId, String processDefinitionId) {
        HistoricProcessInstanceEntity historicProcessInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstanceId)) != null) {
            historicProcessInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordTaskCreated(TaskEntity task, ExecutionEntity execution) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            HistoricTaskInstanceEntity historicTaskInstance = this.getHistoricTaskInstanceEntityManager().create(task, execution);
            this.getHistoricTaskInstanceEntityManager().insert(historicTaskInstance, false);
        }
        this.recordTaskId(task);
    }

    @Override
    public void recordTaskAssignment(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity executionEntity = task.getExecution();
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && executionEntity != null && (historicActivityInstance = this.findActivityInstance(executionEntity, false, true)) != null) {
            historicActivityInstance.setAssignee(task.getAssignee());
        }
    }

    @Override
    public void recordTaskClaim(TaskEntity task) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(task.getId())) != null) {
            historicTaskInstance.setClaimTime(task.getClaimTime());
        }
    }

    @Override
    public void recordTaskId(TaskEntity task) {
        HistoricActivityInstanceEntity historicActivityInstance;
        ExecutionEntity execution;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (execution = task.getExecution()) != null && (historicActivityInstance = this.findActivityInstance(execution, false, true)) != null) {
            historicActivityInstance.setTaskId(task.getId());
        }
    }

    @Override
    public void recordTaskEnd(String taskId, String deleteReason) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.markEnded(deleteReason);
        }
    }

    @Override
    public void recordTaskAssigneeChange(String taskId, String assignee) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setAssignee(assignee);
        }
    }

    @Override
    public void recordTaskOwnerChange(String taskId, String owner) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setOwner(owner);
        }
    }

    @Override
    public void recordTaskNameChange(String taskId, String taskName) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setName(taskName);
        }
    }

    @Override
    public void recordTaskDescriptionChange(String taskId, String description) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setDescription(description);
        }
    }

    @Override
    public void recordTaskDueDateChange(String taskId, Date dueDate) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setDueDate(dueDate);
        }
    }

    @Override
    public void recordTaskPriorityChange(String taskId, int priority) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setPriority(priority);
        }
    }

    @Override
    public void recordTaskCategoryChange(String taskId, String category) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setCategory(category);
        }
    }

    @Override
    public void recordTaskFormKeyChange(String taskId, String formKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setFormKey(formKey);
        }
    }

    @Override
    public void recordTaskParentTaskIdChange(String taskId, String parentTaskId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setParentTaskId(parentTaskId);
        }
    }

    @Override
    public void recordTaskExecutionIdChange(String taskId, String executionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setExecutionId(executionId);
        }
    }

    @Override
    public void recordTaskDefinitionKeyChange(String taskId, String taskDefinitionKey) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setTaskDefinitionKey(taskDefinitionKey);
        }
    }

    @Override
    public void recordTaskProcessDefinitionChange(String taskId, String processDefinitionId) {
        HistoricTaskInstanceEntity historicTaskInstance;
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY) && (historicTaskInstance = (HistoricTaskInstanceEntity)this.getHistoricTaskInstanceEntityManager().findById(taskId)) != null) {
            historicTaskInstance.setProcessDefinitionId(processDefinitionId);
        }
    }

    @Override
    public void recordVariableCreate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            this.getHistoricVariableInstanceEntityManager().copyAndInsert(variable);
        }
    }

    @Override
    public void recordHistoricDetailVariableCreate(VariableInstanceEntity variable, ExecutionEntity sourceActivityExecution, boolean useActivityId) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.FULL)) {
            HistoricActivityInstanceEntity historicActivityInstance;
            HistoricDetailVariableInstanceUpdateEntity historicVariableUpdate = this.getHistoricDetailEntityManager().copyAndInsertHistoricDetailVariableInstanceUpdateEntity(variable);
            if (useActivityId && sourceActivityExecution != null && (historicActivityInstance = this.findActivityInstance(sourceActivityExecution, false, false)) != null) {
                historicVariableUpdate.setActivityInstanceId(historicActivityInstance.getId());
            }
        }
    }

    @Override
    public void recordVariableUpdate(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = this.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                this.getHistoricVariableInstanceEntityManager().copyVariableValue(historicProcessVariable, variable);
            } else {
                this.getHistoricVariableInstanceEntityManager().copyAndInsert(variable);
            }
        }
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(String taskId, String userId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, userId, null, type, create, false);
    }

    @Override
    public void createGroupIdentityLinkComment(String taskId, String groupId, String type, boolean create) {
        this.createIdentityLinkComment(taskId, null, groupId, type, create, false);
    }

    @Override
    public void createUserIdentityLinkComment(String taskId, String userId, String type, boolean create, boolean forceNullUserId) {
        this.createIdentityLinkComment(taskId, userId, null, type, create, forceNullUserId);
    }

    @Override
    public void createIdentityLinkComment(String taskId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setTaskId(taskId);
            if (userId != null || forceNullUserId) {
                if (create) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create) {
        this.createProcessInstanceIdentityLinkComment(processInstanceId, userId, groupId, type, create, false);
    }

    @Override
    public void createProcessInstanceIdentityLinkComment(String processInstanceId, String userId, String groupId, String type, boolean create, boolean forceNullUserId) {
        if (this.isHistoryEnabled()) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(authenticatedUserId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setProcessInstanceId(processInstanceId);
            if (userId != null || forceNullUserId) {
                if (create) {
                    comment.setAction("AddUserLink");
                } else {
                    comment.setAction("DeleteUserLink");
                }
                comment.setMessage(new String[]{userId, type});
            } else {
                if (create) {
                    comment.setAction("AddGroupLink");
                } else {
                    comment.setAction("DeleteGroupLink");
                }
                comment.setMessage(new String[]{groupId, type});
            }
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void createAttachmentComment(String taskId, String processInstanceId, String attachmentName, boolean create) {
        if (this.isHistoryEnabled()) {
            String userId = Authentication.getAuthenticatedUserId();
            CommentEntity comment = (CommentEntity)this.getCommentEntityManager().create();
            comment.setUserId(userId);
            comment.setType("event");
            comment.setTime(this.getClock().getCurrentTime());
            comment.setTaskId(taskId);
            comment.setProcessInstanceId(processInstanceId);
            if (create) {
                comment.setAction("AddAttachment");
            } else {
                comment.setAction("DeleteAttachment");
            }
            comment.setMessage(attachmentName);
            this.getCommentEntityManager().insert(comment);
        }
    }

    @Override
    public void recordIdentityLinkCreated(IdentityLinkEntity identityLink) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT) && (identityLink.getProcessInstanceId() != null || identityLink.getTaskId() != null)) {
            HistoricIdentityLinkEntity historicIdentityLinkEntity = (HistoricIdentityLinkEntity)this.getHistoricIdentityLinkEntityManager().create();
            historicIdentityLinkEntity.setId(identityLink.getId());
            historicIdentityLinkEntity.setGroupId(identityLink.getGroupId());
            historicIdentityLinkEntity.setProcessInstanceId(identityLink.getProcessInstanceId());
            historicIdentityLinkEntity.setTaskId(identityLink.getTaskId());
            historicIdentityLinkEntity.setType(identityLink.getType());
            historicIdentityLinkEntity.setUserId(identityLink.getUserId());
            historicIdentityLinkEntity.setDetails(identityLink.getDetails());
            this.getHistoricIdentityLinkEntityManager().insert(historicIdentityLinkEntity, false);
        }
    }

    @Override
    public void deleteHistoricIdentityLink(String id) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.AUDIT)) {
            this.getHistoricIdentityLinkEntityManager().delete(id);
        }
    }

    @Override
    public void updateProcessBusinessKeyInHistory(ExecutionEntity processInstance) {
        if (this.isHistoryEnabled()) {
            HistoricProcessInstanceEntity historicProcessInstance;
            if (log.isDebugEnabled()) {
                log.debug("updateProcessBusinessKeyInHistory : {}", (Object)processInstance.getId());
            }
            if (processInstance != null && (historicProcessInstance = (HistoricProcessInstanceEntity)this.getHistoricProcessInstanceEntityManager().findById(processInstance.getId())) != null) {
                historicProcessInstance.setBusinessKey(processInstance.getProcessInstanceBusinessKey());
                this.getHistoricProcessInstanceEntityManager().update(historicProcessInstance, false);
            }
        }
    }

    @Override
    public void recordVariableRemoved(VariableInstanceEntity variable) {
        if (this.isHistoryLevelAtLeast(HistoryLevel.ACTIVITY)) {
            HistoricVariableInstanceEntity historicProcessVariable = this.getEntityCache().findInCache(HistoricVariableInstanceEntity.class, variable.getId());
            if (historicProcessVariable == null) {
                historicProcessVariable = this.getHistoricVariableInstanceEntityManager().findHistoricVariableInstanceByVariableInstanceId(variable.getId());
            }
            if (historicProcessVariable != null) {
                this.getHistoricVariableInstanceEntityManager().delete(historicProcessVariable);
            }
        }
    }

    protected String parseActivityType(FlowElement element) {
        Object elementType = element.getClass().getSimpleName();
        elementType = ((String)elementType).substring(0, 1).toLowerCase() + ((String)elementType).substring(1);
        return elementType;
    }

    protected EntityCache getEntityCache() {
        return this.getSession(EntityCache.class);
    }

    public HistoryLevel getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(HistoryLevel historyLevel) {
        this.historyLevel = historyLevel;
    }
}

