/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.io.File;
import java.io.FileInputStream;
import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Properties;
import java.util.TreeSet;

public class DbSchemaExport {
    public static void main(String[] args) throws Exception {
        if (args == null || args.length != 1) {
            System.err.println("Syntax: java -cp ... org.activiti.engine.impl.db.DbSchemaExport <path-to-properties-file> <path-to-export-file>");
            return;
        }
        File propertiesFile = new File(args[0]);
        if (!propertiesFile.exists()) {
            System.err.println("File '" + args[0] + "' doesn't exist \nSyntax: java -cp ... org.activiti.engine.impl.db.DbSchemaExport <path-to-properties-file> <path-to-export-file>\n");
            return;
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(propertiesFile));
        String jdbcDriver = properties.getProperty("jdbc.driver");
        String jdbcUrl = properties.getProperty("jdbc.url");
        String jdbcUsername = properties.getProperty("jdbc.username");
        String jdbcPassword = properties.getProperty("jdbc.password");
        Class.forName(jdbcDriver);
        Connection connection = DriverManager.getConnection(jdbcUrl, jdbcUsername, jdbcPassword);
        try {
            DatabaseMetaData meta = connection.getMetaData();
            TreeSet<String> tableNames = new TreeSet<String>();
            ResultSet tables = meta.getTables(null, null, null, null);
            while (tables.next()) {
                String tableName = tables.getString(3);
                tableNames.add(tableName);
            }
            IO.println((Object)"TABLES");
            for (String tableName : tableNames) {
                HashMap<Object, CallSite> columnDescriptions = new HashMap<Object, CallSite>();
                ResultSet columns = meta.getColumns(null, null, tableName, null);
                while (columns.next()) {
                    String columnName = columns.getString(4);
                    String columnTypeAndSize = columns.getString(6) + " " + columns.getInt(7);
                    columnDescriptions.put(columnName, (CallSite)((Object)columnTypeAndSize));
                }
                IO.println((Object)tableName);
                for (String columnName : new TreeSet(columnDescriptions.keySet())) {
                    IO.println((Object)("  " + columnName + " " + (String)columnDescriptions.get(columnName)));
                }
                IO.println((Object)"INDEXES");
                TreeSet<String> indexNames = new TreeSet<String>();
                ResultSet indexes = meta.getIndexInfo(null, null, tableName, false, true);
                while (indexes.next()) {
                    String indexName = indexes.getString(6);
                    indexNames.add(indexName);
                }
                for (String indexName : indexNames) {
                    IO.println((Object)indexName);
                }
                IO.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            connection.close();
        }
    }
}

