/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity.data.impl.util;

import java.util.List;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionTreeStringBuilder {
    protected ExecutionEntity executionEntity;

    public ExecutionTreeStringBuilder(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.executionEntity.getId()).append(" : ").append(this.executionEntity.getActivityId()).append(", parent id ").append(this.executionEntity.getParentId()).append("\r\n");
        List<? extends ExecutionEntity> children = this.executionEntity.getExecutions();
        if (children != null) {
            for (ExecutionEntity executionEntity : children) {
                this.internalToString(executionEntity, strb, "", true);
            }
        }
        return strb.toString();
    }

    protected void internalToString(ExecutionEntity execution, StringBuilder strb, String prefix, boolean isTail) {
        strb.append(prefix).append(isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ").append(execution.getId()).append(" : ").append("activityId=" + execution.getActivityId()).append(", parent id ").append(execution.getParentId()).append(execution.isScope() ? " (scope)" : "").append(execution.isMultiInstanceRoot() ? " (multi instance root)" : "").append("\r\n");
        List<? extends ExecutionEntity> children = this.executionEntity.getExecutions();
        if (children != null) {
            for (int i = 0; i < children.size() - 1; ++i) {
                this.internalToString(children.get(i), strb, prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (children.size() > 0) {
                this.internalToString(children.getLast(), strb, prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }
    }
}

