/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.io.Serializable;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.cmd.JobType;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.AbstractJobEntity;
import org.activiti.engine.impl.persistence.entity.DeadLetterJobEntity;
import org.activiti.engine.impl.persistence.entity.JobEntity;
import org.activiti.engine.impl.persistence.entity.SuspendedJobEntity;
import org.activiti.engine.impl.persistence.entity.TimerJobEntity;
import org.activiti.engine.runtime.Job;

public class GetJobExceptionStacktraceCmd
implements Command<String>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String jobId;
    protected JobType jobType;

    public GetJobExceptionStacktraceCmd(String jobId, JobType jobType) {
        this.jobId = jobId;
        this.jobType = jobType;
    }

    @Override
    public String execute(CommandContext commandContext) {
        AbstractJobEntity job;
        if (this.jobId == null) {
            throw new ActivitiIllegalArgumentException("jobId is null");
        }
        switch (this.jobType) {
            default: {
                throw new MatchException(null, null);
            }
            case ASYNC: {
                AbstractJobEntity abstractJobEntity = (JobEntity)commandContext.getJobEntityManager().findById(this.jobId);
                break;
            }
            case TIMER: {
                AbstractJobEntity abstractJobEntity = (TimerJobEntity)commandContext.getTimerJobEntityManager().findById(this.jobId);
                break;
            }
            case SUSPENDED: {
                AbstractJobEntity abstractJobEntity = (SuspendedJobEntity)commandContext.getSuspendedJobEntityManager().findById(this.jobId);
                break;
            }
            case DEADLETTER: {
                AbstractJobEntity abstractJobEntity = job = (DeadLetterJobEntity)commandContext.getDeadLetterJobEntityManager().findById(this.jobId);
            }
        }
        if (job == null) {
            throw new ActivitiObjectNotFoundException("No job found with id " + this.jobId, Job.class);
        }
        return job.getExceptionStacktrace();
    }
}

