/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractActivityBpmnParseHandler;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.util.CollectionUtil;
import org.apache.commons.lang3.StringUtils;

public class StartEventParseHandler
extends AbstractActivityBpmnParseHandler<StartEvent> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return StartEvent.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, StartEvent element) {
        if (element.getSubProcess() != null && element.getSubProcess() instanceof EventSubProcess) {
            if (CollectionUtil.isNotEmpty(element.getEventDefinitions())) {
                EventDefinition eventDefinition = (EventDefinition)element.getEventDefinitions().getFirst();
                if (eventDefinition instanceof MessageEventDefinition) {
                    String messageRef;
                    MessageEventDefinition messageDefinition = (MessageEventDefinition)eventDefinition;
                    BpmnModel bpmnModel = bpmnParse.getBpmnModel();
                    if (bpmnModel.containsMessageId(messageRef = messageDefinition.getMessageRef())) {
                        Message message = bpmnModel.getMessage(messageRef);
                        messageDefinition.setMessageRef(message.getName());
                        messageDefinition.setExtensionElements(message.getExtensionElements());
                    }
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessMessageStartEventActivityBehavior(element, messageDefinition));
                } else if (eventDefinition instanceof ErrorEventDefinition) {
                    element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createEventSubProcessErrorStartEventActivityBehavior(element));
                }
            }
        } else if (CollectionUtil.isEmpty(element.getEventDefinitions())) {
            element.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createNoneStartEventActivityBehavior(element));
        }
        if (element.getSubProcess() == null && (CollectionUtil.isEmpty(element.getEventDefinitions()) || bpmnParse.getCurrentProcess().getInitialFlowElement() == null)) {
            bpmnParse.getCurrentProcess().setInitialFlowElement((FlowElement)element);
        }
        this.checkStartFormKey(bpmnParse.getCurrentProcessDefinition(), element);
    }

    private void checkStartFormKey(ProcessDefinitionEntity processDefinition, StartEvent startEvent) {
        if (StringUtils.isNotEmpty((CharSequence)startEvent.getFormKey())) {
            processDefinition.setStartFormKey(true);
        }
    }
}

