/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.test.profiler;

import java.util.Map;
import org.activiti.engine.test.profiler.ActivitiProfiler;
import org.activiti.engine.test.profiler.CommandStats;
import org.activiti.engine.test.profiler.ProfileSession;

public class ConsoleLogger {
    protected ActivitiProfiler profiler;

    public ConsoleLogger(ActivitiProfiler profiler) {
        this.profiler = profiler;
    }

    public void log() {
        for (ProfileSession profileSession : this.profiler.getProfileSessions()) {
            IO.println();
            IO.println((Object)"#############################################");
            IO.println((Object)"#############################################");
            IO.println((Object)profileSession.getName());
            IO.println((Object)"#############################################");
            IO.println((Object)"#############################################");
            IO.println();
            IO.println((Object)("Start time: " + String.valueOf(profileSession.getStartTime())));
            IO.println((Object)("End time: " + String.valueOf(profileSession.getEndTime())));
            IO.println((Object)("Total time: " + profileSession.getTotalTime() + " ms"));
            IO.println();
            Map<String, CommandStats> allStats = profileSession.calculateSummaryStatistics();
            for (String classFqn : allStats.keySet()) {
                CommandStats stats = allStats.get(classFqn);
                IO.println((Object)("Command class: " + classFqn));
                IO.println((Object)("Number of times invoked: " + stats.getCount()));
                double commandPercentage = (double)stats.getTotalCommandTime / (double)profileSession.getTotalTime();
                IO.println((Object)(100.0 * (double)Math.round(commandPercentage * 100.0) / 100.0 + "% of profile session was spent executing this command"));
                IO.println();
                IO.println((Object)("Average execution time: " + stats.getAverageExecutionTime() + " ms (Average database time: " + stats.getAverageDatabaseExecutionTime() + " ms (" + stats.getAverageDatabaseExecutionTimePercentage() + "%) )"));
                IO.println();
                IO.println((Object)"Database selects:");
                for (String select : stats.getDbSelects().keySet()) {
                    IO.println((Object)(select + " : " + String.valueOf(stats.getDbSelects().get(select))));
                }
                IO.println();
                IO.println((Object)"Database inserts:");
                for (String insert : stats.getDbInserts().keySet()) {
                    IO.println((Object)(insert + " : " + String.valueOf(stats.getDbInserts().get(insert))));
                }
                IO.println();
                IO.println((Object)"Database updates:");
                for (String update : stats.getDbUpdates().keySet()) {
                    IO.println((Object)(update + " : " + String.valueOf(stats.getDbSelects().get(update))));
                }
                IO.println();
                IO.println((Object)"Database delete:");
                for (String delete : stats.getDbDeletes().keySet()) {
                    IO.println((Object)(delete + " : " + String.valueOf(stats.getDbDeletes().get(delete))));
                }
                IO.println();
                IO.println();
            }
        }
    }
}

