/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.debug;

import java.util.Iterator;
import java.util.List;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.debug.ExecutionTreeBfsIterator;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;

public class ExecutionTreeNode
implements Iterable<ExecutionTreeNode> {
    protected ExecutionEntity executionEntity;
    protected ExecutionTreeNode parent;
    protected List<ExecutionTreeNode> children;

    public ExecutionTreeNode(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionEntity getExecutionEntity() {
        return this.executionEntity;
    }

    public void setExecutionEntity(ExecutionEntity executionEntity) {
        this.executionEntity = executionEntity;
    }

    public ExecutionTreeNode getParent() {
        return this.parent;
    }

    public void setParent(ExecutionTreeNode parent) {
        this.parent = parent;
    }

    public List<ExecutionTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<ExecutionTreeNode> children) {
        this.children = children;
    }

    @Override
    public Iterator<ExecutionTreeNode> iterator() {
        return new ExecutionTreeBfsIterator(this);
    }

    public ExecutionTreeBfsIterator leafsFirstIterator() {
        return new ExecutionTreeBfsIterator(this, true);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        strb.append(this.getExecutionEntity().getId());
        if (this.getExecutionEntity().getActivityId() != null) {
            strb.append(" : " + this.getExecutionEntity().getActivityId());
        }
        if (this.getExecutionEntity().getParentId() != null) {
            strb.append(", parent id " + this.getExecutionEntity().getParentId());
        }
        if (this.getExecutionEntity().isProcessInstanceType()) {
            strb.append(" (process instance)");
        }
        strb.append(System.lineSeparator());
        if (this.children != null) {
            for (ExecutionTreeNode childNode : this.children) {
                childNode.internalToString(strb, "", true);
            }
        }
        return strb.toString();
    }

    protected void internalToString(StringBuilder strb, String prefix, boolean isTail) {
        strb.append(prefix + (isTail ? "\u2514\u2500\u2500 " : "\u251c\u2500\u2500 ") + this.getExecutionEntity().getId() + " : " + this.getCurrentFlowElementId() + ", parent id " + this.getExecutionEntity().getParentId() + (this.getExecutionEntity().isActive() ? " (active)" : " (not active)") + (this.getExecutionEntity().isScope() ? " (scope)" : "") + (this.getExecutionEntity().isMultiInstanceRoot() ? " (multi instance root)" : "") + (this.getExecutionEntity().isEnded() ? " (ended)" : "") + System.lineSeparator());
        if (this.children != null) {
            for (int i = 0; i < this.children.size() - 1; ++i) {
                this.children.get(i).internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), false);
            }
            if (this.children.size() > 0) {
                this.children.getLast().internalToString(strb, prefix + (isTail ? "    " : "\u2502   "), true);
            }
        }
    }

    protected String getCurrentFlowElementId() {
        FlowElement flowElement = this.getExecutionEntity().getCurrentFlowElement();
        if (flowElement instanceof SequenceFlow) {
            SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
            return sequenceFlow.getSourceRef() + " -> " + sequenceFlow.getTargetRef();
        }
        if (flowElement != null) {
            return flowElement.getId() + " (" + flowElement.getClass().getSimpleName();
        }
        return "";
    }
}

