/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;

public class MessageEventDefinitionParseHandler
extends AbstractBpmnParseHandler<MessageEventDefinition> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return MessageEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, MessageEventDefinition messageDefinition) {
        String messageRef;
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.containsMessageId(messageRef = messageDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageRef);
            messageDefinition.setMessageRef(message.getName());
            messageDefinition.setExtensionElements(message.getExtensionElements());
        }
        if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            IntermediateCatchEvent intermediateCatchEvent = (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement();
            intermediateCatchEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createIntermediateCatchMessageEventActivityBehavior(intermediateCatchEvent, messageDefinition));
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boundaryEvent.setBehavior((Object)bpmnParse.getActivityBehaviorFactory().createBoundaryMessageEventActivityBehavior(boundaryEvent, messageDefinition, boundaryEvent.isCancelActivity()));
        }
    }
}

