/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.Error;
import org.activiti.bpmn.model.ErrorEventDefinition;
import org.activiti.bpmn.model.Event;
import org.activiti.bpmn.model.EventSubProcess;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.MapExceptionEntry;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntityManager;
import org.activiti.engine.impl.util.CollectionUtil;
import org.activiti.engine.impl.util.ProcessDefinitionUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.apache.commons.lang3.StringUtils;

public class ErrorPropagation {
    public static void propagateError(BpmnError error, DelegateExecution execution) {
        ErrorPropagation.propagateError(error.getErrorCode(), execution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void propagateError(String errorRef, DelegateExecution execution) {
        boolean isCatchExecutedForProcess = false;
        boolean isCatchExecutedForCallActivity = false;
        try {
            Map<String, List<Event>> eventMap = ErrorPropagation.findCatchingEventsForProcess(execution.getProcessDefinitionId(), errorRef);
            if (!eventMap.isEmpty()) {
                isCatchExecutedForProcess = ErrorPropagation.executeCatch(eventMap, execution, errorRef);
            }
            if (!isCatchExecutedForProcess && ErrorPropagation.isCallActivity(execution)) {
                isCatchExecutedForCallActivity = ErrorPropagation.findCatchingEventsAndExecuteCatchForCallActivity(errorRef, execution);
            }
        }
        finally {
            if (!isCatchExecutedForProcess && !isCatchExecutedForCallActivity) {
                throw new BpmnError(errorRef, "No catching boundary event found for error with errorCode '" + errorRef + "', neither in same process nor in parent process");
            }
        }
    }

    protected static boolean executeCatch(Map<String, List<Event>> eventMap, DelegateExecution delegateExecution, String errorId) {
        Event matchingEvent = null;
        ExecutionEntity currentExecution = (ExecutionEntity)delegateExecution;
        ExecutionEntity parentExecution = null;
        if (eventMap.containsKey(currentExecution.getActivityId())) {
            matchingEvent = eventMap.get(currentExecution.getActivityId()).get(0);
            parentExecution = currentExecution.getParentId() != null && currentExecution.getParent().isMultiInstanceRoot() ? currentExecution.getParent() : currentExecution;
        } else {
            parentExecution = currentExecution.getParent();
            while (matchingEvent == null && parentExecution != null) {
                FlowElementsContainer currentContainer = null;
                if (parentExecution.getCurrentFlowElement() instanceof FlowElementsContainer) {
                    currentContainer = (FlowElementsContainer)parentExecution.getCurrentFlowElement();
                } else if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                    currentContainer = ProcessDefinitionUtil.getProcess(parentExecution.getProcessDefinitionId());
                }
                for (String refId : eventMap.keySet()) {
                    List<Event> events = eventMap.get(refId);
                    if (!CollectionUtil.isNotEmpty(events) || !(events.get(0) instanceof StartEvent) || currentContainer.getFlowElement(refId) == null) continue;
                    matchingEvent = events.get(0);
                }
                if (matchingEvent != null) continue;
                if (eventMap.containsKey(parentExecution.getActivityId())) {
                    matchingEvent = eventMap.get(parentExecution.getActivityId()).get(0);
                    if (parentExecution.getParentId() == null || !parentExecution.getParent().isMultiInstanceRoot()) continue;
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                if (StringUtils.isNotEmpty((CharSequence)parentExecution.getParentId())) {
                    parentExecution = parentExecution.getParent();
                    continue;
                }
                parentExecution = null;
            }
        }
        if (matchingEvent != null && parentExecution != null) {
            ErrorPropagation.executeEventHandler(matchingEvent, parentExecution, currentExecution, errorId);
            return true;
        }
        return false;
    }

    private static boolean isCallActivity(DelegateExecution delegateExecution) {
        return !delegateExecution.getProcessInstanceId().equals(delegateExecution.getRootProcessInstanceId());
    }

    protected static boolean findCatchingEventsAndExecuteCatchForCallActivity(String errorRef, DelegateExecution execution) {
        ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
        ExecutionEntity processInstanceExecution = (ExecutionEntity)executionEntityManager.findById(execution.getProcessInstanceId());
        Map<Object, Object> eventMap = Collections.emptyMap();
        if (processInstanceExecution != null) {
            ExecutionEntity parentExecution = processInstanceExecution.getSuperExecution();
            HashSet<String> toDeleteProcessInstanceIds = new HashSet<String>();
            toDeleteProcessInstanceIds.add(execution.getProcessInstanceId());
            while (!parentExecution.isRootExecution() && eventMap.isEmpty()) {
                eventMap = ErrorPropagation.findCatchingEventsForProcess(parentExecution.getProcessDefinitionId(), errorRef);
                if (!eventMap.isEmpty()) {
                    for (String processInstanceId : toDeleteProcessInstanceIds) {
                        ErrorPropagation.deleteProcessInstanceEntity(errorRef, execution, executionEntityManager, processInstanceId);
                    }
                    return ErrorPropagation.executeCatch(eventMap, parentExecution, errorRef);
                }
                toDeleteProcessInstanceIds.add(parentExecution.getProcessInstanceId());
                ExecutionEntity superExecution = parentExecution.getSuperExecution();
                if (superExecution != null) {
                    parentExecution = superExecution;
                    continue;
                }
                parentExecution = parentExecution.getProcessInstance();
            }
        }
        return false;
    }

    private static void deleteProcessInstanceEntity(String errorRef, DelegateExecution execution, ExecutionEntityManager executionEntityManager, String processInstanceId) {
        ExecutionEntity processInstanceEntity = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        executionEntityManager.deleteProcessInstanceExecutionEntity(processInstanceEntity.getId(), execution.getCurrentFlowElement() != null ? execution.getCurrentFlowElement().getId() : null, "ERROR_EVENT " + errorRef, false, false);
        ErrorPropagation.dispatchProcessErroredEvent(processInstanceEntity);
    }

    private static void dispatchProcessErroredEvent(ExecutionEntity processInstanceEntity) {
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createEntityEvent(ActivitiEventType.PROCESS_COMPLETED_WITH_ERROR_END_EVENT, processInstanceEntity));
        }
    }

    protected static void executeEventHandler(Event event, ExecutionEntity parentExecution, ExecutionEntity currentExecution, String errorId) {
        BpmnModel bpmnModel;
        if (Context.getProcessEngineConfiguration() != null && Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled() && (bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId())) != null) {
            String errorCode = Optional.ofNullable((Error)bpmnModel.getErrors().get(errorId)).map(Error::getErrorCode).orElse(errorId);
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent(ActivitiEventBuilder.createErrorEvent(ActivitiEventType.ACTIVITY_ERROR_RECEIVED, event.getId(), errorId, errorCode, parentExecution.getId(), parentExecution.getProcessInstanceId(), parentExecution.getProcessDefinitionId()));
        }
        if (event instanceof StartEvent) {
            ExecutionEntityManager executionEntityManager = Context.getCommandContext().getExecutionEntityManager();
            if (!currentExecution.getParentId().equals(parentExecution.getId())) {
                Context.getAgenda().planDestroyScopeOperation(currentExecution);
            } else {
                executionEntityManager.deleteExecutionAndRelatedData(currentExecution, null);
            }
            ExecutionEntity eventSubProcessExecution = executionEntityManager.createChildExecution(parentExecution);
            eventSubProcessExecution.setCurrentFlowElement((FlowElement)event);
            Context.getAgenda().planContinueProcessOperation(eventSubProcessExecution);
        } else {
            ExecutionEntity boundaryExecution = null;
            List<? extends ExecutionEntity> childExecutions = parentExecution.getExecutions();
            for (ExecutionEntity executionEntity : childExecutions) {
                if (!executionEntity.getActivityId().equals(event.getId())) continue;
                boundaryExecution = executionEntity;
            }
            Context.getAgenda().planTriggerExecutionOperation(boundaryExecution);
        }
    }

    protected static Map<String, List<Event>> findCatchingEventsForProcess(String processDefinitionId, String errorRef) {
        HashMap<String, List<Event>> eventMap = new HashMap<String, List<Event>>();
        Process process = ProcessDefinitionUtil.getProcess(processDefinitionId);
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(processDefinitionId);
        String compareErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorRef);
        List subProcesses = process.findFlowElementsOfType(EventSubProcess.class, true);
        for (EventSubProcess eventSubProcess : subProcesses) {
            for (FlowElement flowElement : eventSubProcess.getFlowElements()) {
                String eventErrorCode;
                StartEvent startEvent;
                ErrorEventDefinition errorEventDef;
                if (!(flowElement instanceof StartEvent) || (errorEventDef = ErrorPropagation.getErrorEventDefinition((Event)(startEvent = (StartEvent)flowElement))) == null || !ErrorPropagation.isErrorCodeMatching(eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorEventDef.getErrorRef()), compareErrorCode)) continue;
                eventMap.put(eventSubProcess.getId(), Collections.singletonList(startEvent));
            }
        }
        List boundaryEvents = process.findFlowElementsOfType(BoundaryEvent.class, true);
        ArrayList<BoundaryEvent> boundaryEventsWithoutErrorCode = new ArrayList<BoundaryEvent>();
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            String eventErrorCode;
            ErrorEventDefinition errorEventDef;
            if (boundaryEvent.getAttachedToRefId() == null || (errorEventDef = ErrorPropagation.getErrorEventDefinition((Event)boundaryEvent)) == null || !ErrorPropagation.isErrorCodeMatching(eventErrorCode = ErrorPropagation.retrieveErrorCode(bpmnModel, errorEventDef.getErrorRef()), compareErrorCode)) continue;
            if (eventErrorCode == null) {
                boundaryEventsWithoutErrorCode.add(boundaryEvent);
                continue;
            }
            ErrorPropagation.addBoundaryEventToMap(eventMap, boundaryEvent);
        }
        for (BoundaryEvent boundaryEvent : boundaryEventsWithoutErrorCode) {
            ErrorPropagation.addBoundaryEventToMap(eventMap, boundaryEvent);
        }
        return eventMap;
    }

    private static void addBoundaryEventToMap(Map<String, List<Event>> eventMap, BoundaryEvent boundaryEvent) {
        eventMap.computeIfAbsent(boundaryEvent.getAttachedToRefId(), k -> new ArrayList()).add(boundaryEvent);
    }

    private static ErrorEventDefinition getErrorEventDefinition(Event event) {
        if (CollectionUtil.isNotEmpty(event.getEventDefinitions()) && event.getEventDefinitions().get(0) instanceof ErrorEventDefinition) {
            return (ErrorEventDefinition)event.getEventDefinitions().get(0);
        }
        return null;
    }

    private static boolean isErrorCodeMatching(String eventErrorCode, String compareErrorCode) {
        return eventErrorCode == null || compareErrorCode == null || eventErrorCode.equals(compareErrorCode);
    }

    public static boolean mapException(Exception e, ExecutionEntity execution, List<MapExceptionEntry> exceptionMap) {
        CallActivity callActivity;
        String errorCode = ErrorPropagation.findMatchingExceptionMapping(e, exceptionMap);
        if (errorCode != null) {
            ErrorPropagation.propagateError(errorCode, (DelegateExecution)execution);
            return true;
        }
        DelegateExecution callActivityExecution = null;
        ExecutionEntity parentExecution = execution.getParent();
        while (parentExecution != null && callActivityExecution == null) {
            if (parentExecution.getId().equals(parentExecution.getProcessInstanceId())) {
                if (parentExecution.getSuperExecution() != null) {
                    callActivityExecution = parentExecution.getSuperExecution();
                    continue;
                }
                parentExecution = null;
                continue;
            }
            parentExecution = parentExecution.getParent();
        }
        if (callActivityExecution != null && CollectionUtil.isNotEmpty((callActivity = (CallActivity)callActivityExecution.getCurrentFlowElement()).getMapExceptions()) && (errorCode = ErrorPropagation.findMatchingExceptionMapping(e, callActivity.getMapExceptions())) != null) {
            ErrorPropagation.propagateError(errorCode, callActivityExecution);
            return true;
        }
        return false;
    }

    protected static String findMatchingExceptionMapping(Exception e, List<MapExceptionEntry> exceptionMap) {
        String defaultExceptionMapping = null;
        for (MapExceptionEntry me : exceptionMap) {
            Class<?> exceptionClassClass;
            String exceptionClass = me.getClassName();
            String errorCode = me.getErrorCode();
            if (StringUtils.isNotEmpty((CharSequence)errorCode) && StringUtils.isEmpty((CharSequence)exceptionClass) && defaultExceptionMapping == null) {
                defaultExceptionMapping = errorCode;
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)errorCode) || StringUtils.isEmpty((CharSequence)exceptionClass)) continue;
            if (e.getClass().getName().equals(exceptionClass)) {
                return errorCode;
            }
            if (!me.isAndChildren() || !(exceptionClassClass = ReflectUtil.loadClass(exceptionClass)).isAssignableFrom(e.getClass())) continue;
            return errorCode;
        }
        return defaultExceptionMapping;
    }

    protected static String retrieveErrorCode(BpmnModel bpmnModel, String errorRef) {
        return Optional.ofNullable(errorRef).map(ref -> {
            if (bpmnModel.containsErrorRef(errorRef)) {
                return Optional.ofNullable((Error)bpmnModel.getErrors().get(errorRef)).map(Error::getErrorCode).orElse(errorRef);
            }
            return errorRef;
        }).orElse(errorRef);
    }
}

