/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.impl.ProcessInstanceCreationOptions;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.deploy.DeploymentManager;
import org.activiti.engine.impl.persistence.entity.MessageEventSubscriptionEntity;
import org.activiti.engine.impl.runtime.ProcessInstanceBuilderImpl;
import org.activiti.engine.impl.util.ProcessInstanceHelper;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;

public class StartProcessInstanceByMessageCmd
implements Command<ProcessInstance> {
    protected String messageName;
    protected String businessKey;
    protected Map<String, Object> processVariables;
    protected Map<String, Object> transientVariables;
    protected String tenantId;
    protected String linkedProcessInstanceId;
    protected String linkedProcessInstanceType;

    public StartProcessInstanceByMessageCmd(String messageName, String businessKey, Map<String, Object> processVariables, String tenantId) {
        this.messageName = messageName;
        this.businessKey = businessKey;
        this.processVariables = processVariables;
        this.tenantId = tenantId;
    }

    public StartProcessInstanceByMessageCmd(ProcessInstanceBuilderImpl processInstanceBuilder) {
        this.messageName = processInstanceBuilder.getMessageName();
        this.businessKey = processInstanceBuilder.getBusinessKey();
        this.processVariables = processInstanceBuilder.getVariables();
        this.transientVariables = processInstanceBuilder.getTransientVariables();
        this.tenantId = processInstanceBuilder.getTenantId();
        this.linkedProcessInstanceId = processInstanceBuilder.getLinkedProcessInstanceId();
        this.linkedProcessInstanceType = processInstanceBuilder.getLinkedProcessInstanceType();
    }

    @Override
    public ProcessInstance execute(CommandContext commandContext) {
        if (this.messageName == null) {
            throw new ActivitiIllegalArgumentException("Cannot start process instance by message: message name is null");
        }
        MessageEventSubscriptionEntity messageEventSubscription = commandContext.getEventSubscriptionEntityManager().findMessageStartEventSubscriptionByName(this.messageName, this.tenantId);
        if (messageEventSubscription == null) {
            throw new ActivitiObjectNotFoundException("Cannot start process instance by message: no subscription to message with name '" + this.messageName + "' found.", MessageEventSubscriptionEntity.class);
        }
        String processDefinitionId = messageEventSubscription.getConfiguration();
        if (processDefinitionId == null) {
            throw new ActivitiException("Cannot start process instance by message: subscription to message with name '" + this.messageName + "' is not a message start event.");
        }
        DeploymentManager deploymentCache = commandContext.getProcessEngineConfiguration().getDeploymentManager();
        ProcessDefinition processDefinition = deploymentCache.findDeployedProcessDefinitionById(processDefinitionId);
        if (processDefinition == null) {
            throw new ActivitiObjectNotFoundException("No process definition found for id '" + processDefinitionId + "'", ProcessDefinition.class);
        }
        ProcessInstanceHelper processInstanceHelper = commandContext.getProcessEngineConfiguration().getProcessInstanceHelper();
        ProcessInstanceCreationOptions options = ProcessInstanceCreationOptions.builder(processDefinition).businessKey(this.businessKey).variables(this.processVariables).transientVariables(this.transientVariables).linkedProcessInstanceId(this.linkedProcessInstanceId).linkedProcessInstanceType(this.linkedProcessInstanceType).build();
        return processInstanceHelper.createAndStartProcessInstanceByMessage(options, this.messageName);
    }
}

