/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BooleanDataObject;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DateDataObject;
import org.activiti.bpmn.model.DoubleDataObject;
import org.activiti.bpmn.model.EventListener;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.ImplementationType;
import org.activiti.bpmn.model.IntegerDataObject;
import org.activiti.bpmn.model.ItemDefinition;
import org.activiti.bpmn.model.LongDataObject;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.Signal;
import org.activiti.bpmn.model.StringDataObject;
import org.activiti.bpmn.model.UserTask;
import org.activiti.bpmn.model.ValuedDataObject;
import org.activiti.editor.constants.EditorJsonConstants;
import org.activiti.editor.constants.StencilConstants;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnJsonConverterUtil
implements EditorJsonConstants,
StencilConstants {
    private static final Logger logger = LoggerFactory.getLogger(BpmnJsonConverterUtil.class);
    private static DateTimeFormatter dateTimeFormatter = ISODateTimeFormat.dateTimeParser();
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static ObjectNode createChildShape(String id, String type, double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode shapeNode = objectMapper.createObjectNode();
        shapeNode.set("bounds", (JsonNode)BpmnJsonConverterUtil.createBoundsNode(lowerRightX, lowerRightY, upperLeftX, upperLeftY));
        shapeNode.put("resourceId", id);
        ArrayNode shapesArrayNode = objectMapper.createArrayNode();
        shapeNode.set("childShapes", (JsonNode)shapesArrayNode);
        ObjectNode stencilNode = objectMapper.createObjectNode();
        stencilNode.put("id", type);
        shapeNode.set("stencil", (JsonNode)stencilNode);
        return shapeNode;
    }

    public static ObjectNode createBoundsNode(double lowerRightX, double lowerRightY, double upperLeftX, double upperLeftY) {
        ObjectNode boundsNode = objectMapper.createObjectNode();
        boundsNode.set("lowerRight", (JsonNode)BpmnJsonConverterUtil.createPositionNode(lowerRightX, lowerRightY));
        boundsNode.set("upperLeft", (JsonNode)BpmnJsonConverterUtil.createPositionNode(upperLeftX, upperLeftY));
        return boundsNode;
    }

    public static ObjectNode createPositionNode(double x, double y) {
        ObjectNode positionNode = objectMapper.createObjectNode();
        positionNode.put("x", x);
        positionNode.put("y", y);
        return positionNode;
    }

    public static ObjectNode createResourceNode(String id) {
        ObjectNode resourceNode = objectMapper.createObjectNode();
        resourceNode.put("resourceId", id);
        return resourceNode;
    }

    public static String getStencilId(JsonNode objectNode) {
        String stencilId = null;
        JsonNode stencilNode = objectNode.get("stencil");
        if (stencilNode != null && stencilNode.get("id") != null) {
            stencilId = stencilNode.get("id").asText();
        }
        return stencilId;
    }

    public static String getElementId(JsonNode objectNode) {
        String elementId = null;
        elementId = StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode)) ? BpmnJsonConverterUtil.getPropertyValueAsString("overrideid", objectNode).trim() : objectNode.get("resourceId").asText();
        return elementId;
    }

    public static void convertMessagesToJson(Collection<Message> messages, ObjectNode propertiesNode) {
        String propertyName = "messages";
        ArrayNode messagesNode = objectMapper.createArrayNode();
        for (Message message : messages) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("message_id", message.getId());
            propertyItemNode.put("message_name", message.getName());
            propertyItemNode.put("message_item_ref", message.getItemRef());
            messagesNode.add((JsonNode)propertyItemNode);
        }
        propertiesNode.set(propertyName, (JsonNode)messagesNode);
    }

    public static void convertListenersToJson(List<ActivitiListener> listeners, boolean isExecutionListener, ObjectNode propertiesNode) {
        String propertyName = null;
        String valueName = null;
        if (isExecutionListener) {
            propertyName = "executionlisteners";
            valueName = "executionListeners";
        } else {
            propertyName = "tasklisteners";
            valueName = "taskListeners";
        }
        ObjectNode listenersNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (ActivitiListener listener : listeners) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("event", listener.getEvent());
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                propertyItemNode.put("className", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put("expression", listener.getImplementation());
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put("delegateExpression", listener.getImplementation());
            }
            if (CollectionUtils.isNotEmpty(listener.getFieldExtensions())) {
                ArrayNode fieldsArray = objectMapper.createArrayNode();
                for (FieldExtension fieldExtension : listener.getFieldExtensions()) {
                    ObjectNode fieldNode = objectMapper.createObjectNode();
                    fieldNode.put("name", fieldExtension.getFieldName());
                    if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getStringValue())) {
                        fieldNode.put("stringValue", fieldExtension.getStringValue());
                    }
                    if (StringUtils.isNotEmpty((CharSequence)fieldExtension.getExpression())) {
                        fieldNode.put("expression", fieldExtension.getExpression());
                    }
                    fieldsArray.add((JsonNode)fieldNode);
                }
                propertyItemNode.set("fields", (JsonNode)fieldsArray);
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.set(valueName, (JsonNode)itemsNode);
        propertiesNode.set(propertyName, (JsonNode)listenersNode);
    }

    public static void convertEventListenersToJson(List<EventListener> listeners, ObjectNode propertiesNode) {
        ObjectNode listenersNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (EventListener listener : listeners) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)listener.getEvents())) {
                String[] eventArray;
                ArrayNode eventArrayNode = objectMapper.createArrayNode();
                for (String eventValue : eventArray = listener.getEvents().split(",")) {
                    if (!StringUtils.isNotEmpty((CharSequence)eventValue.trim())) continue;
                    ObjectNode eventNode = objectMapper.createObjectNode();
                    eventNode.put("event", eventValue.trim());
                    eventArrayNode.add((JsonNode)eventNode);
                }
                propertyItemNode.put("event", listener.getEvents());
                propertyItemNode.set("events", (JsonNode)eventArrayNode);
            }
            Object implementationText = null;
            if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(listener.getImplementationType())) {
                propertyItemNode.put("className", listener.getImplementation());
                implementationText = listener.getImplementation();
            } else if (ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(listener.getImplementationType())) {
                propertyItemNode.put("delegateExpression", listener.getImplementation());
                implementationText = listener.getImplementation();
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "error");
                propertyItemNode.put("errorcode", listener.getImplementation());
                implementationText = "Rethrow as error " + listener.getImplementation();
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "message");
                propertyItemNode.put("messagename", listener.getImplementation());
                implementationText = "Rethrow as message " + listener.getImplementation();
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "signal");
                propertyItemNode.put("signalname", listener.getImplementation());
                implementationText = "Rethrow as signal " + listener.getImplementation();
            } else if (ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT.equals(listener.getImplementationType())) {
                propertyItemNode.put("rethrowEvent", true);
                propertyItemNode.put("rethrowType", "globalSignal");
                propertyItemNode.put("signalname", listener.getImplementation());
                implementationText = "Rethrow as signal " + listener.getImplementation();
            }
            if (StringUtils.isNotEmpty((CharSequence)implementationText)) {
                propertyItemNode.put("implementation", (String)implementationText);
            }
            if (StringUtils.isNotEmpty((CharSequence)listener.getEntityType())) {
                propertyItemNode.put("entityType", listener.getEntityType());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        listenersNode.set("eventListeners", (JsonNode)itemsNode);
        propertiesNode.set("eventlisteners", (JsonNode)listenersNode);
    }

    public static void convertSignalDefinitionsToJson(BpmnModel bpmnModel, ObjectNode propertiesNode) {
        if (bpmnModel.getSignals() != null) {
            ArrayNode signalDefinitions = objectMapper.createArrayNode();
            for (Signal signal : bpmnModel.getSignals()) {
                ObjectNode signalNode = signalDefinitions.addObject();
                signalNode.put("id", signal.getId());
                signalNode.put("name", signal.getName());
                signalNode.put("scope", signal.getScope());
            }
            propertiesNode.set("signaldefinitions", (JsonNode)signalDefinitions);
        }
    }

    public static void convertMessagesToJson(BpmnModel bpmnModel, ObjectNode propertiesNode) {
        if (bpmnModel.getMessages() != null) {
            ArrayNode messageDefinitions = objectMapper.createArrayNode();
            for (Message message : bpmnModel.getMessages()) {
                ObjectNode messageNode = messageDefinitions.addObject();
                messageNode.put("id", message.getId());
                messageNode.put("name", message.getName());
            }
            propertiesNode.set("messagedefinitions", (JsonNode)messageDefinitions);
        }
    }

    public static void convertJsonToListeners(JsonNode objectNode, BaseElement element) {
        JsonNode taskListenersNode;
        JsonNode executionListenersNode = BpmnJsonConverterUtil.getProperty("executionlisteners", objectNode);
        if (executionListenersNode != null) {
            executionListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(executionListenersNode);
            JsonNode listenersNode = executionListenersNode.get("executionListeners");
            BpmnJsonConverterUtil.parseListeners(listenersNode, element, false);
        }
        if (element instanceof UserTask && (taskListenersNode = BpmnJsonConverterUtil.getProperty("tasklisteners", objectNode)) != null) {
            taskListenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(taskListenersNode);
            JsonNode listenersNode = taskListenersNode.get("taskListeners");
            BpmnJsonConverterUtil.parseListeners(listenersNode, element, true);
        }
    }

    public static void convertJsonToMessages(JsonNode objectNode, BpmnModel element) {
        JsonNode messagesNode = BpmnJsonConverterUtil.getProperty("messagedefinitions", objectNode);
        if (messagesNode != null) {
            messagesNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(messagesNode);
            BpmnJsonConverterUtil.parseMessages(messagesNode, element);
        }
    }

    protected static void parseListeners(JsonNode listenersNode, BaseElement element, boolean isTaskListener) {
        if (listenersNode == null) {
            return;
        }
        listenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenersNode);
        for (JsonNode listenerNode : listenersNode) {
            JsonNode eventNode = (listenerNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenerNode)).get("event");
            if (eventNode == null || eventNode.isNull() || !StringUtils.isNotEmpty((CharSequence)eventNode.asText())) continue;
            ActivitiListener listener = new ActivitiListener();
            listener.setEvent(eventNode.asText());
            if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("className", listenerNode))) {
                listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("className", listenerNode));
            } else if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("expression", listenerNode))) {
                listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION);
                listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("expression", listenerNode));
            } else if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode))) {
                listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode));
            }
            JsonNode fieldsNode = listenerNode.get("fields");
            if (fieldsNode != null) {
                for (JsonNode fieldNode : fieldsNode) {
                    JsonNode nameNode = fieldNode.get("name");
                    if (nameNode == null || nameNode.isNull() || !StringUtils.isNotEmpty((CharSequence)nameNode.asText())) continue;
                    FieldExtension fieldExtension = new FieldExtension();
                    fieldExtension.setFieldName(nameNode.asText());
                    fieldExtension.setStringValue(BpmnJsonConverterUtil.getValueAsString("stringValue", fieldNode));
                    if (StringUtils.isEmpty((CharSequence)fieldExtension.getStringValue())) {
                        fieldExtension.setStringValue(BpmnJsonConverterUtil.getValueAsString("string", fieldNode));
                    }
                    if (StringUtils.isEmpty((CharSequence)fieldExtension.getStringValue())) {
                        fieldExtension.setExpression(BpmnJsonConverterUtil.getValueAsString("expression", fieldNode));
                    }
                    listener.getFieldExtensions().add(fieldExtension);
                }
            }
            if (element instanceof Process) {
                ((Process)element).getExecutionListeners().add(listener);
                continue;
            }
            if (element instanceof SequenceFlow) {
                ((SequenceFlow)element).getExecutionListeners().add(listener);
                continue;
            }
            if (element instanceof UserTask) {
                if (isTaskListener) {
                    ((UserTask)element).getTaskListeners().add(listener);
                    continue;
                }
                ((UserTask)element).getExecutionListeners().add(listener);
                continue;
            }
            if (!(element instanceof FlowElement)) continue;
            ((FlowElement)element).getExecutionListeners().add(listener);
        }
    }

    protected static void parseMessages(JsonNode messagesNode, BpmnModel element) {
        if (messagesNode == null) {
            return;
        }
        for (JsonNode messageNode : messagesNode) {
            String messageItemRef;
            String messageName;
            Message message = new Message();
            String messageId = BpmnJsonConverterUtil.getValueAsString("id", messageNode);
            if (StringUtils.isNotEmpty((CharSequence)messageId)) {
                message.setId(messageId);
            }
            if (StringUtils.isNotEmpty((CharSequence)(messageName = BpmnJsonConverterUtil.getValueAsString("name", messageNode)))) {
                message.setName(messageName);
            }
            if (StringUtils.isNotEmpty((CharSequence)(messageItemRef = BpmnJsonConverterUtil.getValueAsString("message_item_ref", messageNode)))) {
                message.setItemRef(messageItemRef);
            }
            if (!StringUtils.isNotEmpty((CharSequence)messageId)) continue;
            element.addMessage(message);
        }
    }

    public static void parseEventListeners(JsonNode listenersNode, Process process) {
        if (listenersNode == null) {
            return;
        }
        listenersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual(listenersNode);
        for (JsonNode listenerNode : listenersNode) {
            JsonNode eventsNode = listenerNode.get("events");
            if (eventsNode == null || !eventsNode.isArray() || eventsNode.size() <= 0) continue;
            EventListener listener = new EventListener();
            StringBuilder eventsBuilder = new StringBuilder();
            for (JsonNode eventNode : eventsNode) {
                JsonNode eventValueNode = eventNode.get("event");
                if (eventValueNode == null || eventValueNode.isNull() || !StringUtils.isNotEmpty((CharSequence)eventValueNode.asText())) continue;
                if (eventsBuilder.length() > 0) {
                    eventsBuilder.append(",");
                }
                eventsBuilder.append(eventValueNode.asText());
            }
            if (eventsBuilder.length() == 0) continue;
            listener.setEvents(eventsBuilder.toString());
            JsonNode rethrowEventNode = listenerNode.get("rethrowEvent");
            if (rethrowEventNode != null && rethrowEventNode.asBoolean()) {
                JsonNode rethrowTypeNode = listenerNode.get("rethrowType");
                if (rethrowTypeNode != null) {
                    String signalName;
                    if ("error".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        String errorCode = BpmnJsonConverterUtil.getValueAsString("errorcode", listenerNode);
                        if (StringUtils.isNotEmpty((CharSequence)errorCode)) {
                            listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_ERROR_EVENT);
                            listener.setImplementation(errorCode);
                        }
                    } else if ("message".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        String messageName = BpmnJsonConverterUtil.getValueAsString("messagename", listenerNode);
                        if (StringUtils.isNotEmpty((CharSequence)messageName)) {
                            listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_MESSAGE_EVENT);
                            listener.setImplementation(messageName);
                        }
                    } else if ("signal".equalsIgnoreCase(rethrowTypeNode.asText())) {
                        signalName = BpmnJsonConverterUtil.getValueAsString("signalname", listenerNode);
                        if (StringUtils.isNotEmpty((CharSequence)signalName)) {
                            listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_SIGNAL_EVENT);
                            listener.setImplementation(signalName);
                        }
                    } else if ("globalSignal".equalsIgnoreCase(rethrowTypeNode.asText()) && StringUtils.isNotEmpty((CharSequence)(signalName = BpmnJsonConverterUtil.getValueAsString("signalname", listenerNode)))) {
                        listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_THROW_GLOBAL_SIGNAL_EVENT);
                        listener.setImplementation(signalName);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)listener.getImplementation())) {
                    continue;
                }
            } else {
                if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("className", listenerNode))) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_CLASS);
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("className", listenerNode));
                } else if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode))) {
                    listener.setImplementationType(ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION);
                    listener.setImplementation(BpmnJsonConverterUtil.getValueAsString("delegateExpression", listenerNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)BpmnJsonConverterUtil.getValueAsString("entityType", listenerNode))) {
                    listener.setEntityType(BpmnJsonConverterUtil.getValueAsString("entityType", listenerNode));
                }
                if (StringUtils.isEmpty((CharSequence)listener.getImplementation())) continue;
            }
            process.getEventListeners().add(listener);
        }
    }

    public static String lookForSourceRef(String flowId, JsonNode childShapesNode) {
        String sourceRef = null;
        if (childShapesNode != null) {
            for (JsonNode childNode : childShapesNode) {
                JsonNode outgoingNode = childNode.get("outgoing");
                if (outgoingNode != null && outgoingNode.size() > 0) {
                    for (JsonNode outgoingChildNode : outgoingNode) {
                        JsonNode resourceNode = outgoingChildNode.get("resourceId");
                        if (resourceNode == null || !flowId.equals(resourceNode.asText())) continue;
                        sourceRef = BpmnJsonConverterUtil.getElementId(childNode);
                        break;
                    }
                    if (sourceRef != null) break;
                }
                if ((sourceRef = BpmnJsonConverterUtil.lookForSourceRef(flowId, childNode.get("childShapes"))) == null) continue;
                break;
            }
        }
        return sourceRef;
    }

    public static List<ValuedDataObject> convertJsonToDataProperties(JsonNode objectNode, BaseElement element) {
        ArrayList<ValuedDataObject> dataObjects = new ArrayList<ValuedDataObject>();
        if (objectNode != null) {
            JsonNode itemsArrayNode;
            if (objectNode.isValueNode() && StringUtils.isNotEmpty((CharSequence)objectNode.asText())) {
                try {
                    objectNode = objectMapper.readTree(objectNode.asText());
                }
                catch (Exception e) {
                    logger.info("Data properties node cannot be read", (Throwable)e);
                }
            }
            if ((itemsArrayNode = objectNode.get("items")) != null) {
                for (JsonNode dataNode : itemsArrayNode) {
                    JsonNode dataIdNode = dataNode.get("dataproperty_id");
                    if (dataIdNode == null || !StringUtils.isNotEmpty((CharSequence)dataIdNode.asText())) continue;
                    StringDataObject dataObject = null;
                    ItemDefinition itemSubjectRef = new ItemDefinition();
                    String dataType = dataNode.get("dataproperty_type").asText();
                    if (dataType.equals("string")) {
                        dataObject = new StringDataObject();
                    } else if (dataType.equals("int")) {
                        dataObject = new IntegerDataObject();
                    } else if (dataType.equals("long")) {
                        dataObject = new LongDataObject();
                    } else if (dataType.equals("double")) {
                        dataObject = new DoubleDataObject();
                    } else if (dataType.equals("boolean")) {
                        dataObject = new BooleanDataObject();
                    } else if (dataType.equals("datetime")) {
                        dataObject = new DateDataObject();
                    } else {
                        logger.error("Error converting {}", (Object)dataIdNode.asText());
                    }
                    if (null == dataObject) continue;
                    dataObject.setId(dataIdNode.asText());
                    dataObject.setName(dataNode.get("dataproperty_name").asText());
                    itemSubjectRef.setStructureRef("xsd:" + dataType);
                    dataObject.setItemSubjectRef(itemSubjectRef);
                    if (dataObject instanceof DateDataObject) {
                        try {
                            dataObject.setValue((Object)dateTimeFormatter.parseDateTime(dataNode.get("dataproperty_value").asText()).toDate());
                        }
                        catch (Exception e) {
                            logger.error("Error converting {}", (Object)dataObject.getName(), (Object)e);
                        }
                    } else {
                        dataObject.setValue((Object)dataNode.get("dataproperty_value").asText());
                    }
                    dataObjects.add((ValuedDataObject)dataObject);
                }
            }
        }
        return dataObjects;
    }

    public static void convertDataPropertiesToJson(List<ValuedDataObject> dataObjects, ObjectNode propertiesNode) {
        ObjectNode dataPropertiesNode = objectMapper.createObjectNode();
        ArrayNode itemsNode = objectMapper.createArrayNode();
        for (ValuedDataObject dObj : dataObjects) {
            ObjectNode propertyItemNode = objectMapper.createObjectNode();
            propertyItemNode.put("dataproperty_id", dObj.getId());
            propertyItemNode.put("dataproperty_name", dObj.getName());
            String itemSubjectRefQName = dObj.getItemSubjectRef().getStructureRef();
            String dataType = itemSubjectRefQName.substring(itemSubjectRefQName.indexOf(58) + 1);
            propertyItemNode.put("dataproperty_type", dataType);
            Object dObjValue = dObj.getValue();
            String value = new String();
            if (null == dObjValue) {
                propertyItemNode.put("dataproperty_value", "");
            } else {
                value = "datetime".equals(dataType) ? new DateTime(dObjValue).toString("yyyy-MM-dd'T'hh:mm:ss") : new String(dObjValue.toString());
                propertyItemNode.put("dataproperty_value", value.toString());
            }
            itemsNode.add((JsonNode)propertyItemNode);
        }
        dataPropertiesNode.set("items", (JsonNode)itemsNode);
        propertiesNode.set("dataproperties", (JsonNode)dataPropertiesNode);
    }

    public static JsonNode validateIfNodeIsTextual(JsonNode node) {
        if (node != null && !node.isNull() && node.isTextual() && StringUtils.isNotEmpty((CharSequence)node.asText())) {
            try {
                node = BpmnJsonConverterUtil.validateIfNodeIsTextual(objectMapper.readTree(node.asText()));
            }
            catch (Exception e) {
                logger.error("Error converting textual node", (Throwable)e);
            }
        }
        return node;
    }

    public static String getValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = objectNode.get(name);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static String getPropertyValueAsString(String name, JsonNode objectNode) {
        String propertyValue = null;
        JsonNode propertyNode = BpmnJsonConverterUtil.getProperty(name, objectNode);
        if (propertyNode != null && !propertyNode.isNull()) {
            propertyValue = propertyNode.asText();
        }
        return propertyValue;
    }

    public static JsonNode getProperty(String name, JsonNode objectNode) {
        JsonNode propertyNode = null;
        if (objectNode.get("properties") != null) {
            JsonNode propertiesNode = objectNode.get("properties");
            propertyNode = propertiesNode.get(name);
        }
        return propertyNode;
    }
}

