/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.editor.language.json.converter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.UserTask;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.FormAwareConverter;
import org.activiti.editor.language.json.converter.FormKeyAwareConverter;
import org.activiti.editor.language.json.converter.util.CollectionUtils;
import org.activiti.editor.language.json.model.ModelInfo;
import org.apache.commons.lang3.StringUtils;

public class UserTaskJsonConverter
extends BaseBpmnJsonConverter
implements FormAwareConverter,
FormKeyAwareConverter {
    protected Map<String, String> formMap;
    protected Map<String, ModelInfo> formKeyMap;

    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        UserTaskJsonConverter.fillJsonTypes(convertersToBpmnMap);
        UserTaskJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("UserTask", UserTaskJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(UserTask.class, UserTaskJsonConverter.class);
    }

    @Override
    protected String getStencilId(BaseElement baseElement) {
        return "UserTask";
    }

    @Override
    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        UserTask userTask = (UserTask)baseElement;
        String assignee = userTask.getAssignee();
        if (StringUtils.isNotEmpty((CharSequence)assignee) || CollectionUtils.isNotEmpty(userTask.getCandidateUsers()) || CollectionUtils.isNotEmpty(userTask.getCandidateGroups())) {
            ObjectNode assignmentNode = this.objectMapper.createObjectNode();
            ObjectNode assignmentValuesNode = this.objectMapper.createObjectNode();
            List idmAssigneeList = (List)userTask.getExtensionElements().get("activiti-idm-assignee");
            List idmAssigneeFieldList = (List)userTask.getExtensionElements().get("activiti-idm-assignee-field");
            if (CollectionUtils.isNotEmpty(idmAssigneeList) || CollectionUtils.isNotEmpty(idmAssigneeFieldList) || CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-user")) || CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get("activiti-idm-candidate-group"))) {
                assignmentValuesNode.put("type", "idm");
                ObjectNode idmNode = this.objectMapper.createObjectNode();
                assignmentValuesNode.set("idm", (JsonNode)idmNode);
                List canCompleteList = (List)userTask.getExtensionElements().get("initiator-can-complete");
                if (CollectionUtils.isNotEmpty(canCompleteList)) {
                    assignmentValuesNode.put("initiatorCanCompleteTask", Boolean.valueOf(((ExtensionElement)canCompleteList.getFirst()).getElementText()));
                }
                if (StringUtils.isNotEmpty((CharSequence)userTask.getAssignee())) {
                    ObjectNode assigneeNode = this.objectMapper.createObjectNode();
                    if (userTask.getAssignee().contains("${taskAssignmentBean.assignTaskToAssignee(")) {
                        idmNode.set("assigneeField", (JsonNode)assigneeNode);
                        idmNode.put("type", "user");
                        this.fillProperty("id", "activiti-idm-assignee-field", assigneeNode, userTask);
                        this.fillProperty("name", "assignee-field-info-name", assigneeNode, userTask);
                    } else {
                        assigneeNode.put("id", userTask.getAssignee());
                        idmNode.set("assignee", (JsonNode)assigneeNode);
                        idmNode.put("type", "user");
                        this.fillProperty("externalId", "assignee-info-externalid", assigneeNode, userTask);
                        this.fillProperty("email", "assignee-info-email", assigneeNode, userTask);
                        this.fillProperty("firstName", "assignee-info-firstname", assigneeNode, userTask);
                        this.fillProperty("lastName", "assignee-info-lastname", assigneeNode, userTask);
                    }
                }
                List idmCandidateUserList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-user");
                if (CollectionUtils.isNotEmpty(userTask.getCandidateUsers()) && CollectionUtils.isNotEmpty(idmCandidateUserList)) {
                    ArrayList<String> candidateUserIds = new ArrayList<String>();
                    if (userTask.getCandidateUsers().size() == 1 && ((String)userTask.getCandidateUsers().getFirst()).contains("${taskAssignmentBean.assignTaskToCandidateUsers(")) {
                        String[] candidateUserArray;
                        idmNode.put("type", "users");
                        String candidateUsersString = (String)userTask.getCandidateUsers().getFirst();
                        candidateUsersString = candidateUsersString.replace("${taskAssignmentBean.assignTaskToCandidateUsers('", "");
                        candidateUsersString = candidateUsersString.replace("', execution)}", "");
                        ArrayList candidateFieldIds = new ArrayList();
                        for (String candidate : candidateUserArray = candidateUsersString.split(",")) {
                            if (candidate.contains("field(")) {
                                candidateFieldIds.add(candidate.trim().substring(6, candidate.length() - 1));
                                continue;
                            }
                            candidateUserIds.add(candidate.trim());
                        }
                        if (candidateFieldIds.size() > 0) {
                            ArrayNode candidateUserFieldsNode = this.objectMapper.createArrayNode();
                            idmNode.set("candidateUserFields", (JsonNode)candidateUserFieldsNode);
                            Iterator iterator = candidateFieldIds.iterator();
                            while (iterator.hasNext()) {
                                String fieldId = (String)iterator.next();
                                ObjectNode fieldNode = this.objectMapper.createObjectNode();
                                fieldNode.put("id", fieldId);
                                candidateUserFieldsNode.add((JsonNode)fieldNode);
                                this.fillProperty("name", "user-field-info-name-" + fieldId, fieldNode, userTask);
                            }
                        }
                    } else {
                        candidateUserIds.addAll(userTask.getCandidateUsers());
                    }
                    if (candidateUserIds.size() > 0) {
                        ArrayNode candidateUsersNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateUsers", (JsonNode)candidateUsersNode);
                        idmNode.put("type", "users");
                        for (String candidateUser : candidateUserIds) {
                            ObjectNode candidateUserNode = this.objectMapper.createObjectNode();
                            candidateUserNode.put("id", candidateUser);
                            candidateUsersNode.add((JsonNode)candidateUserNode);
                            this.fillProperty("externalId", "user-info-externalid-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("email", "user-info-email-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("firstName", "user-info-firstname-" + candidateUser, candidateUserNode, userTask);
                            this.fillProperty("lastName", "user-info-lastname-" + candidateUser, candidateUserNode, userTask);
                        }
                    }
                }
                List idmCandidateGroupList = (List)userTask.getExtensionElements().get("activiti-idm-candidate-group");
                if (CollectionUtils.isNotEmpty(userTask.getCandidateGroups()) && CollectionUtils.isNotEmpty(idmCandidateGroupList)) {
                    ArrayList<String> candidateGroupIds = new ArrayList<String>();
                    if (userTask.getCandidateGroups().size() == 1 && ((String)userTask.getCandidateGroups().getFirst()).contains("${taskAssignmentBean.assignTaskToCandidateGroups(")) {
                        String[] candidateGroupArray;
                        idmNode.put("type", "groups");
                        String candidateGroupsString = (String)userTask.getCandidateGroups().getFirst();
                        candidateGroupsString = candidateGroupsString.replace("${taskAssignmentBean.assignTaskToCandidateGroups('", "");
                        candidateGroupsString = candidateGroupsString.replace("', execution)}", "");
                        ArrayList<String> candidateFieldIds = new ArrayList<String>();
                        for (String candidate : candidateGroupArray = candidateGroupsString.split(",")) {
                            if (candidate.contains("field(")) {
                                candidateFieldIds.add(candidate.trim().substring(6, candidate.length() - 1));
                                continue;
                            }
                            candidateGroupIds.add(candidate.trim());
                        }
                        if (candidateFieldIds.size() > 0) {
                            ArrayNode candidateGroupFieldsNode = this.objectMapper.createArrayNode();
                            idmNode.set("candidateGroupFields", (JsonNode)candidateGroupFieldsNode);
                            for (String fieldId : candidateFieldIds) {
                                ObjectNode fieldNode = this.objectMapper.createObjectNode();
                                fieldNode.put("id", fieldId);
                                candidateGroupFieldsNode.add((JsonNode)fieldNode);
                                this.fillProperty("name", "group-field-info-name-" + fieldId, fieldNode, userTask);
                            }
                        }
                    } else {
                        candidateGroupIds.addAll(userTask.getCandidateGroups());
                    }
                    if (candidateGroupIds.size() > 0) {
                        ArrayNode candidateGroupsNode = this.objectMapper.createArrayNode();
                        idmNode.set("candidateGroups", (JsonNode)candidateGroupsNode);
                        idmNode.put("type", "groups");
                        for (String candidateGroup : candidateGroupIds) {
                            ObjectNode candidateGroupNode = this.objectMapper.createObjectNode();
                            candidateGroupNode.put("id", candidateGroup);
                            candidateGroupsNode.add((JsonNode)candidateGroupNode);
                            this.fillProperty("externalId", "group-info-externalid-" + candidateGroup, candidateGroupNode, userTask);
                            this.fillProperty("name", "group-info-name-" + candidateGroup, candidateGroupNode, userTask);
                        }
                    }
                }
            } else {
                ObjectNode candidateNode;
                ArrayNode candidateArrayNode;
                assignmentValuesNode.put("type", "static");
                if (StringUtils.isNotEmpty((CharSequence)assignee)) {
                    assignmentValuesNode.put("assignee", assignee);
                }
                if (CollectionUtils.isNotEmpty(userTask.getCandidateUsers())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateUser : userTask.getCandidateUsers()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateUser);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateUsers", (JsonNode)candidateArrayNode);
                }
                if (CollectionUtils.isNotEmpty(userTask.getCandidateGroups())) {
                    candidateArrayNode = this.objectMapper.createArrayNode();
                    for (String candidateGroup : userTask.getCandidateGroups()) {
                        candidateNode = this.objectMapper.createObjectNode();
                        candidateNode.put("value", candidateGroup);
                        candidateArrayNode.add((JsonNode)candidateNode);
                    }
                    assignmentValuesNode.set("candidateGroups", (JsonNode)candidateArrayNode);
                }
            }
            assignmentNode.set("assignment", (JsonNode)assignmentValuesNode);
            propertiesNode.set("usertaskassignment", (JsonNode)assignmentNode);
        }
        if (userTask.getPriority() != null) {
            this.setPropertyValue("prioritydefinition", userTask.getPriority(), propertiesNode);
        }
        if (StringUtils.isNotEmpty((CharSequence)userTask.getFormKey())) {
            if (this.formKeyMap != null && this.formKeyMap.containsKey(userTask.getFormKey())) {
                ObjectNode formRefNode = this.objectMapper.createObjectNode();
                ModelInfo modelInfo = this.formKeyMap.get(userTask.getFormKey());
                formRefNode.put("id", modelInfo.getId());
                formRefNode.put("name", modelInfo.getName());
                formRefNode.put("key", modelInfo.getKey());
                propertiesNode.set("formreference", (JsonNode)formRefNode);
            } else {
                this.setPropertyValue("formkeydefinition", userTask.getFormKey(), propertiesNode);
            }
        }
        this.setPropertyValue("duedatedefinition", userTask.getDueDate(), propertiesNode);
        this.setPropertyValue("categorydefinition", userTask.getCategory(), propertiesNode);
        this.addFormProperties(userTask.getFormProperties(), propertiesNode);
    }

    protected int getExtensionElementValueAsInt(String name, UserTask userTask) {
        int intValue = 0;
        String value = this.getExtensionElementValue(name, userTask);
        if (value != null && value.chars().allMatch(Character::isDigit)) {
            intValue = Integer.parseInt(value);
        }
        return intValue;
    }

    protected String getExtensionElementValue(String name, UserTask userTask) {
        String value = "";
        if (CollectionUtils.isNotEmpty((Collection)userTask.getExtensionElements().get(name))) {
            ExtensionElement extensionElement = (ExtensionElement)((List)userTask.getExtensionElements().get(name)).getFirst();
            value = extensionElement.getElementText();
        }
        return value;
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        JsonNode assignmentDefNode;
        UserTask task = new UserTask();
        task.setPriority(this.getPropertyValueAsString("prioritydefinition", elementNode));
        String formKey = this.getPropertyValueAsString("formkeydefinition", elementNode);
        if (StringUtils.isNotEmpty((CharSequence)formKey)) {
            task.setFormKey(formKey);
        } else {
            JsonNode formReferenceNode = this.getProperty("formreference", elementNode);
            if (formReferenceNode != null && formReferenceNode.get("id") != null && this.formMap != null && this.formMap.containsKey(formReferenceNode.get("id").asText())) {
                task.setFormKey(this.formMap.get(formReferenceNode.get("id").asText()));
            }
        }
        task.setDueDate(this.getPropertyValueAsString("duedatedefinition", elementNode));
        task.setCategory(this.getPropertyValueAsString("categorydefinition", elementNode));
        JsonNode assignmentNode = this.getProperty("usertaskassignment", elementNode);
        if (assignmentNode != null && (assignmentDefNode = assignmentNode.get("assignment")) != null) {
            JsonNode idmDefNode;
            JsonNode typeNode = assignmentDefNode.get("type");
            JsonNode canCompleteTaskNode = assignmentDefNode.get("initiatorCanCompleteTask");
            if (typeNode == null || "static".equalsIgnoreCase(typeNode.asText())) {
                JsonNode assigneeNode = assignmentDefNode.get("assignee");
                if (assigneeNode != null && !assigneeNode.isNull()) {
                    task.setAssignee(assigneeNode.asText());
                }
                task.setCandidateUsers(this.getValueAsList("candidateUsers", assignmentDefNode));
                task.setCandidateGroups(this.getValueAsList("candidateGroups", assignmentDefNode));
                if (StringUtils.isNotEmpty((CharSequence)task.getAssignee()) && !"$INITIATOR".equalsIgnoreCase(task.getAssignee())) {
                    if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                        this.addInitiatorCanCompleteExtensionElement(Boolean.parseBoolean(canCompleteTaskNode.asText()), task);
                    } else {
                        this.addInitiatorCanCompleteExtensionElement(false, task);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)task.getAssignee()) && "$INITIATOR".equalsIgnoreCase(task.getAssignee())) {
                    this.addInitiatorCanCompleteExtensionElement(true, task);
                }
            } else if ("idm".equalsIgnoreCase(typeNode.asText()) && (idmDefNode = assignmentDefNode.get("idm")) != null && idmDefNode.has("type")) {
                JsonNode idmTypeNode = idmDefNode.get("type");
                if (idmTypeNode != null && "user".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("assignee") || idmDefNode.has("assigneeField"))) {
                    this.fillAssigneeInfo(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "users".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("candidateUsers") || idmDefNode.has("candidateUserFields"))) {
                    this.fillCandidateUsers(idmDefNode, canCompleteTaskNode, task);
                } else if (idmTypeNode != null && "groups".equalsIgnoreCase(idmTypeNode.asText()) && (idmDefNode.has("candidateGroups") || idmDefNode.has("candidateGroupFields"))) {
                    this.fillCandidateGroups(idmDefNode, canCompleteTaskNode, task);
                } else {
                    task.setAssignee("$INITIATOR");
                    this.addExtensionElement("activiti-idm-initiator", String.valueOf(true), task);
                }
            }
        }
        this.convertJsonToFormProperties(elementNode, (BaseElement)task);
        return task;
    }

    protected void fillAssigneeInfo(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode idNode;
        JsonNode assigneeNode = idmDefNode.get("assignee");
        JsonNode assigneeFieldNode = idmDefNode.get("assigneeField");
        if (assigneeNode != null && !assigneeNode.isNull()) {
            JsonNode idNode2 = assigneeNode.get("id");
            JsonNode emailNode = assigneeNode.get("email");
            if (idNode2 != null && !idNode2.isNull() && StringUtils.isNotEmpty((CharSequence)idNode2.asText())) {
                task.setAssignee(idNode2.asText());
                this.addExtensionElement("activiti-idm-assignee", String.valueOf(true), task);
                this.addExtensionElement("assignee-info-email", emailNode, task);
                this.addExtensionElement("assignee-info-firstname", assigneeNode.get("firstName"), task);
                this.addExtensionElement("assignee-info-lastname", assigneeNode.get("lastName"), task);
                this.addExtensionElement("assignee-info-externalid", assigneeNode.get("externalId"), task);
            } else if (emailNode != null && !emailNode.isNull() && StringUtils.isNotEmpty((CharSequence)emailNode.asText())) {
                task.setAssignee(emailNode.asText());
                this.addExtensionElement("activiti-assignee-email", task.getAssignee(), task);
                this.addExtensionElement("activiti-idm-assignee", String.valueOf(true), task);
            }
        } else if (assigneeFieldNode != null && !assigneeFieldNode.isNull() && (idNode = assigneeFieldNode.get("id")) != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
            task.setAssignee("${taskAssignmentBean.assignTaskToAssignee('" + idNode.asText() + "', execution)}");
            this.addExtensionElement("activiti-idm-assignee-field", idNode.asText(), task);
            this.addExtensionElement("assignee-field-info-name", assigneeFieldNode.get("name"), task);
        }
        if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
            this.addInitiatorCanCompleteExtensionElement(Boolean.parseBoolean(canCompleteTaskNode.asText()), task);
        } else {
            this.addInitiatorCanCompleteExtensionElement(false, task);
        }
    }

    protected void fillCandidateUsers(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateUserFieldsNode;
        JsonNode idNode;
        ArrayList<Object> candidateUsers = new ArrayList<Object>();
        JsonNode candidateUsersNode = idmDefNode.get("candidateUsers");
        if (candidateUsersNode != null && candidateUsersNode.isArray()) {
            ArrayList<String> emails = new ArrayList<String>();
            for (JsonNode userNode : candidateUsersNode) {
                if (userNode == null || userNode.isNull()) continue;
                idNode = userNode.get("id");
                JsonNode emailNode = userNode.get("email");
                if (idNode != null && !idNode.isNull() && StringUtils.isNotEmpty((CharSequence)idNode.asText())) {
                    String id = idNode.asText();
                    candidateUsers.add(id);
                    this.addExtensionElement("user-info-email-" + id, emailNode, task);
                    this.addExtensionElement("user-info-firstname-" + id, userNode.get("firstName"), task);
                    this.addExtensionElement("user-info-lastname-" + id, userNode.get("lastName"), task);
                    this.addExtensionElement("user-info-externalid-" + id, userNode.get("externalId"), task);
                    continue;
                }
                if (emailNode == null || emailNode.isNull() || !StringUtils.isNotEmpty((CharSequence)emailNode.asText())) continue;
                String email = emailNode.asText();
                candidateUsers.add(email);
                emails.add(email);
            }
            if (emails.size() > 0) {
                this.addExtensionElement("activiti-candidate-users-emails", StringUtils.join(emails, (String)","), task);
            }
            if (candidateUsers.size() > 0) {
                this.addExtensionElement("activiti-idm-candidate-user", String.valueOf(true), task);
                if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                    this.addInitiatorCanCompleteExtensionElement(Boolean.parseBoolean(canCompleteTaskNode.asText()), task);
                } else {
                    this.addInitiatorCanCompleteExtensionElement(false, task);
                }
            }
        }
        if ((candidateUserFieldsNode = idmDefNode.get("candidateUserFields")) != null && candidateUserFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateUserFieldsNode) {
                idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                String id = idNode.asText();
                candidateUsers.add("field(" + id + ")");
                this.addExtensionElement("user-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateUsers.size() > 0) {
            if (candidateUserFieldsNode != null && candidateUserFieldsNode.isArray() && candidateUserFieldsNode.size() > 0) {
                Object candidateUsersString = StringUtils.join(candidateUsers, (String)",");
                candidateUsersString = "${taskAssignmentBean.assignTaskToCandidateUsers('" + (String)candidateUsersString + "', execution)}";
                candidateUsers.clear();
                candidateUsers.add(candidateUsersString);
                task.setCandidateUsers(candidateUsers);
            } else {
                task.setCandidateUsers(candidateUsers);
            }
        }
    }

    protected void fillCandidateGroups(JsonNode idmDefNode, JsonNode canCompleteTaskNode, UserTask task) {
        JsonNode candidateGroupFieldsNode;
        String id;
        ArrayList<Object> candidateGroups = new ArrayList<Object>();
        JsonNode candidateGroupsNode = idmDefNode.get("candidateGroups");
        if (candidateGroupsNode != null && candidateGroupsNode.isArray()) {
            for (Iterator groupNode : candidateGroupsNode) {
                if (groupNode == null || groupNode.isNull()) continue;
                JsonNode idNode = groupNode.get("id");
                JsonNode nameNode = groupNode.get("name");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add(id);
                this.addExtensionElement("group-info-name-" + id, nameNode, task);
                this.addExtensionElement("group-info-externalid-" + id, groupNode.get("externalId"), task);
            }
        }
        if ((candidateGroupFieldsNode = idmDefNode.get("candidateGroupFields")) != null && candidateGroupFieldsNode.isArray()) {
            for (JsonNode fieldNode : candidateGroupFieldsNode) {
                JsonNode idNode = fieldNode.get("id");
                if (idNode == null || idNode.isNull() || !StringUtils.isNotEmpty((CharSequence)idNode.asText())) continue;
                id = idNode.asText();
                candidateGroups.add("field(" + id + ")");
                this.addExtensionElement("group-field-info-name-" + id, fieldNode.get("name"), task);
            }
        }
        if (candidateGroups.size() > 0) {
            if (candidateGroupFieldsNode != null && candidateGroupFieldsNode.isArray() && candidateGroupFieldsNode.size() > 0) {
                Object candidateGroupsString = StringUtils.join(candidateGroups, (String)",");
                candidateGroupsString = "${taskAssignmentBean.assignTaskToCandidateGroups('" + (String)candidateGroupsString + "', execution)}";
                candidateGroups.clear();
                candidateGroups.add(candidateGroupsString);
                task.setCandidateGroups(candidateGroups);
            } else {
                task.setCandidateGroups(candidateGroups);
            }
            this.addExtensionElement("activiti-idm-candidate-group", String.valueOf(true), task);
            if (canCompleteTaskNode != null && !canCompleteTaskNode.isNull()) {
                this.addInitiatorCanCompleteExtensionElement(Boolean.parseBoolean(canCompleteTaskNode.asText()), task);
            } else {
                this.addInitiatorCanCompleteExtensionElement(false, task);
            }
        }
    }

    protected void addInitiatorCanCompleteExtensionElement(boolean canCompleteTask, UserTask task) {
        this.addExtensionElement("initiator-can-complete", String.valueOf(canCompleteTask), task);
    }

    protected void addExtensionElement(String name, JsonNode elementNode, UserTask task) {
        if (elementNode != null && !elementNode.isNull() && StringUtils.isNotEmpty((CharSequence)elementNode.asText())) {
            this.addExtensionElement(name, elementNode.asText(), task);
        }
    }

    protected void addExtensionElement(String name, String elementText, UserTask task) {
        ExtensionElement extensionElement = new ExtensionElement();
        extensionElement.setNamespace("http://activiti.com/modeler");
        extensionElement.setNamespacePrefix("modeler");
        extensionElement.setName(name);
        extensionElement.setElementText(elementText);
        task.addExtensionElement(extensionElement);
    }

    protected void fillProperty(String propertyName, String extensionElementName, ObjectNode elementNode, UserTask task) {
        List extensionElementList = (List)task.getExtensionElements().get(extensionElementName);
        if (CollectionUtils.isNotEmpty(extensionElementList)) {
            elementNode.put(propertyName, ((ExtensionElement)extensionElementList.getFirst()).getElementText());
        }
    }

    @Override
    public void setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
    }

    @Override
    public void setFormKeyMap(Map<String, ModelInfo> formKeyMap) {
        this.formKeyMap = formKeyMap;
    }
}

