/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class StartEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List startEvents = process.findFlowElementsOfType(StartEvent.class, false);
        this.validateEventDefinitionTypes(startEvents, process, errors);
        this.validateMultipleStartEvents(startEvents, process, errors);
    }

    protected void validateEventDefinitionTypes(List<StartEvent> startEvents, Process process, List<ValidationError> errors) {
        for (StartEvent startEvent : startEvents) {
            EventDefinition eventDefinition;
            if (startEvent.getEventDefinitions() == null || startEvent.getEventDefinitions().isEmpty() || (eventDefinition = (EventDefinition)startEvent.getEventDefinitions().getFirst()) instanceof MessageEventDefinition || eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition) continue;
            this.addError(errors, "START_EVENT_INVALID_EVENT_DEFINITION", process, (BaseElement)startEvent);
        }
    }

    protected void validateMultipleStartEvents(List<StartEvent> startEvents, Process process, List<ValidationError> errors) {
        ArrayList<StartEvent> noneStartEvents = new ArrayList<StartEvent>();
        for (StartEvent startEvent : startEvents) {
            if (startEvent.getEventDefinitions() != null && !startEvent.getEventDefinitions().isEmpty()) continue;
            noneStartEvents.add(startEvent);
        }
        if (noneStartEvents.size() > 1) {
            for (StartEvent startEvent : noneStartEvents) {
                this.addError(errors, "START_EVENT_MULTIPLE_FOUND", process, (BaseElement)startEvent);
            }
        }
    }
}

