/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ErrorMessageDefinition;
import org.apache.commons.text.StringSubstitutor;

public class ValidationErrorDecorator {
    public static final String PARAM_PREFIX = "{{";
    public static final String PARAM_SUFFIX = "}}";
    private Map<String, ErrorMessageDefinition> errorMessages;

    public ValidationErrorDecorator() {
        this.init();
    }

    public void init() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            TypeReference<Map<String, ErrorMessageDefinition>> typeReference = new TypeReference<Map<String, ErrorMessageDefinition>>(this){
                {
                    Objects.requireNonNull(this$0);
                }
            };
            InputStream inputStream = this.getClass().getResourceAsStream("/process-validation-messages.json");
            this.errorMessages = (Map)objectMapper.readValue(inputStream, (TypeReference)typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load error messages", e);
        }
    }

    public void decorate(ValidationError error) {
        error.setProblem(this.resolveMessage(this.errorMessages.get(error.getKey()).getProblem(), error.getParams()));
        error.setDefaultDescription(this.resolveMessage(this.errorMessages.get(error.getKey()).getDescription(), error.getParams()));
    }

    public String resolveMessage(String message, Map<String, String> params) {
        StringSubstitutor sub = new StringSubstitutor(params, PARAM_PREFIX, PARAM_SUFFIX);
        return sub.replace(message);
    }
}

