/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.LinkEventDefinition;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SignalEventDefinition;
import org.activiti.bpmn.model.TimerEventDefinition;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class IntermediateCatchEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List intermediateCatchEvents = process.findFlowElementsOfType(IntermediateCatchEvent.class);
        for (IntermediateCatchEvent intermediateCatchEvent : intermediateCatchEvents) {
            EventDefinition eventDefinition = null;
            if (!intermediateCatchEvent.getEventDefinitions().isEmpty()) {
                eventDefinition = (EventDefinition)intermediateCatchEvent.getEventDefinitions().getFirst();
            }
            if (eventDefinition == null) {
                this.addError(errors, "INTERMEDIATE_CATCH_EVENT_NO_EVENTDEFINITION", process, (BaseElement)intermediateCatchEvent);
                continue;
            }
            if (eventDefinition instanceof TimerEventDefinition || eventDefinition instanceof SignalEventDefinition || eventDefinition instanceof MessageEventDefinition || eventDefinition instanceof LinkEventDefinition) continue;
            this.addError(errors, "INTERMEDIATE_CATCH_EVENT_INVALID_EVENTDEFINITION", process, (BaseElement)intermediateCatchEvent);
        }
    }
}

