/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class BpmnModelValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        boolean isAtLeastOneExecutable;
        List<Process> processesDuplicated = this.getProcessesWithSameId(bpmnModel.getProcesses());
        if (!processesDuplicated.isEmpty()) {
            this.addError(errors, "PROCESS_DEFINITION_ID_NOT_UNIQUE", (BaseElement)processesDuplicated.get(0));
        }
        if (isAtLeastOneExecutable = this.validateAtLeastOneExecutable(bpmnModel, errors)) {
            for (Process process : bpmnModel.getProcesses()) {
                if (!process.isExecutable()) {
                    this.addWarning(errors, "PROCESS_DEFINITION_NOT_EXECUTABLE", process, (BaseElement)process);
                }
                this.handleProcessConstraints(bpmnModel, process, errors);
            }
        }
        this.handleBPMNModelConstraints(bpmnModel, errors);
    }

    protected void handleProcessConstraints(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        HashMap<String, String> params;
        if (process.getId() != null && process.getId().length() > 255) {
            params = new HashMap<String, String>();
            params.put("maxLength", String.valueOf(255));
            this.addError(errors, "PROCESS_DEFINITION_ID_TOO_LONG", (BaseElement)process, params);
        }
        if (process.getName() != null && process.getName().length() > 255) {
            params = new HashMap();
            params.put("maxLength", String.valueOf(255));
            this.addError(errors, "PROCESS_DEFINITION_NAME_TOO_LONG", (BaseElement)process, params);
        }
        if (process.getDocumentation() != null && process.getDocumentation().length() > 2000) {
            params = new HashMap();
            params.put("maxLength", String.valueOf(2000));
            this.addError(errors, "PROCESS_DEFINITION_DOCUMENTATION_TOO_LONG", (BaseElement)process, params);
        }
    }

    protected void handleBPMNModelConstraints(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getTargetNamespace() != null && bpmnModel.getTargetNamespace().length() > 255) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("maxLength", String.valueOf(255));
            this.addError(errors, "BPMN_MODEL_TARGET_NAMESPACE_TOO_LONG", params);
        }
    }

    protected boolean validateAtLeastOneExecutable(BpmnModel bpmnModel, List<ValidationError> errors) {
        int nrOfExecutableDefinitions = 0;
        for (Process process : bpmnModel.getProcesses()) {
            if (!process.isExecutable()) continue;
            ++nrOfExecutableDefinitions;
        }
        if (nrOfExecutableDefinitions == 0) {
            this.addError(errors, "ALL_PROCESS_DEFINITIONS_NOT_EXECUTABLE");
        }
        return nrOfExecutableDefinitions > 0;
    }

    protected List<Process> getProcessesWithSameId(List<Process> processes) {
        List<Process> filteredProcesses = processes.stream().filter(process -> process.getName() != null).collect(Collectors.toList());
        return BpmnModelValidator.getDuplicatesMap(filteredProcesses).values().stream().filter(duplicates -> duplicates.size() > 1).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private static Map<String, List<Process>> getDuplicatesMap(List<Process> processes) {
        return processes.stream().collect(Collectors.groupingBy(BaseElement::getId));
    }
}

