/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import jakarta.el.ELContext;
import java.util.List;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.core.el.juel.ExpressionFactoryImpl;
import org.activiti.core.el.juel.util.SimpleContext;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;
import org.apache.commons.lang3.StringUtils;

public class SequenceflowValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List sequenceFlows = process.findFlowElementsOfType(SequenceFlow.class);
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            String conditionExpression;
            String sourceRef = sequenceFlow.getSourceRef();
            String targetRef = sequenceFlow.getTargetRef();
            if (StringUtils.isEmpty((CharSequence)sourceRef)) {
                this.addError(errors, "SEQ_FLOW_INVALID_SRC", process, (BaseElement)sequenceFlow);
            }
            if (StringUtils.isEmpty((CharSequence)targetRef)) {
                this.addError(errors, "SEQ_FLOW_INVALID_TARGET", process, (BaseElement)sequenceFlow);
            }
            FlowElement source = process.getFlowElement(sourceRef, true);
            FlowElement target = process.getFlowElement(targetRef, true);
            if (source == null) {
                this.addError(errors, "SEQ_FLOW_INVALID_SRC", process, (BaseElement)sequenceFlow);
            }
            if (target == null) {
                this.addError(errors, "SEQ_FLOW_INVALID_TARGET", process, (BaseElement)sequenceFlow);
            }
            if (source != null && target != null) {
                FlowElementsContainer sourceContainer = process.getFlowElementsContainer(source.getId());
                FlowElementsContainer targetContainer = process.getFlowElementsContainer(target.getId());
                if (sourceContainer == null) {
                    this.addError(errors, "SEQ_FLOW_INVALID_SRC", process, (BaseElement)sequenceFlow);
                }
                if (targetContainer == null) {
                    this.addError(errors, "SEQ_FLOW_INVALID_TARGET", process, (BaseElement)sequenceFlow);
                }
                if (sourceContainer != null && targetContainer != null && !sourceContainer.equals((Object)targetContainer)) {
                    this.addError(errors, "SEQ_FLOW_INVALID_TARGET_DIFFERENT_SCOPE", process, (BaseElement)sequenceFlow);
                }
            }
            if ((conditionExpression = sequenceFlow.getConditionExpression()) == null) continue;
            try {
                new ExpressionFactoryImpl().createValueExpression((ELContext)new SimpleContext(), conditionExpression.trim(), Object.class);
            }
            catch (Exception e) {
                this.addError(errors, "SEQ_FLOW_INVALID_CONDITIONAL_EXPRESSION", process, (BaseElement)sequenceFlow);
            }
        }
    }
}

