/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.Objects;
import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionContext
implements TransactionContext {
    protected PlatformTransactionManager transactionManager;
    protected CommandContext commandContext;
    protected Integer transactionSynchronizationAdapterOrder;

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext) {
        this(transactionManager, commandContext, null);
    }

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext, Integer transactionSynchronizationAdapterOrder) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder != null ? transactionSynchronizationAdapterOrder : Integer.valueOf(Integer.MAX_VALUE);
    }

    public void commit() {
    }

    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        if (transactionState.equals((Object)TransactionState.COMMITTING)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(this){
                final /* synthetic */ SpringTransactionContext this$0;
                {
                    SpringTransactionContext springTransactionContext = this$0;
                    Objects.requireNonNull(springTransactionContext);
                    this.this$0 = springTransactionContext;
                    super(this$0);
                }

                @Override
                public void beforeCommit(boolean readOnly) {
                    transactionListener.execute(this.this$0.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.COMMITTED)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(this){
                final /* synthetic */ SpringTransactionContext this$0;
                {
                    SpringTransactionContext springTransactionContext = this$0;
                    Objects.requireNonNull(springTransactionContext);
                    this.this$0 = springTransactionContext;
                    super(this$0);
                }

                @Override
                public void afterCommit() {
                    transactionListener.execute(this.this$0.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLINGBACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(this){
                final /* synthetic */ SpringTransactionContext this$0;
                {
                    SpringTransactionContext springTransactionContext = this$0;
                    Objects.requireNonNull(springTransactionContext);
                    this.this$0 = springTransactionContext;
                    super(this$0);
                }

                @Override
                public void beforeCompletion() {
                    transactionListener.execute(this.this$0.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLED_BACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(this){
                final /* synthetic */ SpringTransactionContext this$0;
                {
                    SpringTransactionContext springTransactionContext = this$0;
                    Objects.requireNonNull(springTransactionContext);
                    this.this$0 = springTransactionContext;
                    super(this$0);
                }

                @Override
                public void afterCompletion(int status) {
                    if (1 == status) {
                        transactionListener.execute(this.this$0.commandContext);
                    }
                }
            });
        }
    }

    protected abstract class TransactionSynchronizationAdapter
    implements TransactionSynchronization,
    Ordered {
        final /* synthetic */ SpringTransactionContext this$0;

        protected TransactionSynchronizationAdapter(SpringTransactionContext this$0) {
            SpringTransactionContext springTransactionContext = this$0;
            Objects.requireNonNull(springTransactionContext);
            this.this$0 = springTransactionContext;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }

        public int getOrder() {
            return this.this$0.transactionSynchronizationAdapterOrder;
        }
    }
}

