/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import java.util.Objects;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.impl.interceptor.AbstractCommandInterceptor;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SpringTransactionInterceptor
extends AbstractCommandInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringTransactionInterceptor.class);
    protected PlatformTransactionManager transactionManager;

    public SpringTransactionInterceptor(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public <T> T execute(final CommandConfig config, final Command<T> command) {
        LOGGER.debug("Running command with propagation {}", (Object)config.getTransactionPropagation());
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setPropagationBehavior(this.getPropagation(config));
        Object result = transactionTemplate.execute(new TransactionCallback<T>(){
            final /* synthetic */ SpringTransactionInterceptor this$0;
            {
                SpringTransactionInterceptor springTransactionInterceptor = this$0;
                Objects.requireNonNull(springTransactionInterceptor);
                this.this$0 = springTransactionInterceptor;
            }

            public T doInTransaction(TransactionStatus status) {
                return this.this$0.next.execute(config, command);
            }
        });
        return (T)result;
    }

    private int getPropagation(CommandConfig config) {
        switch (config.getTransactionPropagation()) {
            case NOT_SUPPORTED: {
                return 4;
            }
            case REQUIRED: {
                return 0;
            }
            case REQUIRES_NEW: {
                return 3;
            }
        }
        throw new ActivitiIllegalArgumentException("Unsupported transaction propagation: " + String.valueOf(config.getTransactionPropagation()));
    }
}

