/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.streams;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.audit.api.converters.APIEventToEntityConverters;
import org.activiti.cloud.services.audit.api.converters.EventToEntityConverter;
import org.activiti.cloud.services.audit.api.streams.AuditConsumerChannelHandler;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.activiti.cloud.services.audit.jpa.repository.EventsRepository;
import org.activiti.cloud.services.audit.service.TeamsChatService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.handler.annotation.Headers;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.REQUIRES_NEW)
public class AuditConsumerChannelHandlerImpl
implements AuditConsumerChannelHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(AuditConsumerChannelHandlerImpl.class);
    private final EventsRepository eventsRepository;
    private final APIEventToEntityConverters eventConverters;
    private TeamsChatService teamsChatService;

    public AuditConsumerChannelHandlerImpl(EventsRepository eventsRepository, APIEventToEntityConverters eventConverters, TeamsChatService teamsChatService) {
        this.eventsRepository = eventsRepository;
        this.eventConverters = eventConverters;
        this.teamsChatService = teamsChatService;
    }

    @Override
    public void receiveCloudRuntimeEvent(@Headers Map<String, Object> headers, CloudRuntimeEvent<?, ?> ... events) {
        if (events != null) {
            AtomicInteger counter = new AtomicInteger(0);
            ArrayList<AuditEventEntity> entities = new ArrayList<AuditEventEntity>();
            for (CloudRuntimeEvent<?, ?> event : events) {
                EventToEntityConverter converter = this.eventConverters.getConverterByEventTypeName(event.getEventType().name());
                if (converter != null) {
                    ((CloudRuntimeEventImpl)event).setMessageId(headers.get("id").toString());
                    ((CloudRuntimeEventImpl)event).setSequenceNumber(Integer.valueOf(counter.getAndIncrement()));
                    entities.add((AuditEventEntity)converter.convertToEntity(event));
                    if (this.teamsChatService == null) continue;
                    this.sendTeamsNotifcationCardToDevops((CloudRuntimeEventImpl)event);
                    continue;
                }
                LOGGER.warn(">>> Ignoring CloudRuntimeEvents type: " + event.getEventType().name());
            }
            this.eventsRepository.saveAll(entities);
        }
    }

    private void sendTeamsNotifcationToDevops(CloudRuntimeEventImpl event) {
        StringBuilder sb = new StringBuilder();
        sb.append("New Audit Event from " + event.getAppName() + " app * ");
        sb.append("Event Type: " + String.valueOf(event.getEventType()) + " -- ");
        CompletableFuture<Void> future = this.teamsChatService.sendSimpleMessage("9d1a5f8a-9abc-4ed1-8dda-522ba3d2ef45", sb.toString());
        future.join();
    }

    private void sendTeamsNotifcationCardToDevops(CloudRuntimeEventImpl event) {
        LinkedHashMap<String, String> processData = new LinkedHashMap<String, String>();
        processData.put("Event Type", event.getEventType().name());
        Date date = new Date(event.getTimestamp());
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.mmm'Z'");
        processData.put("Date", f.format(date));
        processData.put("Event ID", event.getId());
        processData.put("Process Instance ID", event.getProcessInstanceId());
        CompletableFuture<Void> future = this.teamsChatService.sendAdaptiveCard("9d1a5f8a-9abc-4ed1-8dda-522ba3d2ef45", "HXP Audit Event", "A new HXP Audit event for app: " + event.getAppName(), processData, event.getActor());
        future.join();
    }

    public void setTeamsChatService(TeamsChatService service) {
        this.teamsChatService = service;
    }
}

