/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.audit.jpa.security;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.activiti.cloud.services.audit.jpa.events.AuditEventEntity;
import org.springframework.data.jpa.domain.Specification;

public class ApplicationProcessDefSecuritySpecification
implements Specification<AuditEventEntity> {
    private String serviceName;
    private Set<String> processDefinitions = new HashSet<String>();

    public ApplicationProcessDefSecuritySpecification(String serviceName, Set<String> processDefinitions) {
        this.serviceName = serviceName;
        this.processDefinitions = processDefinitions;
    }

    public Set<String> getProcessDefinitions() {
        return this.processDefinitions;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Predicate toPredicate(Root<AuditEventEntity> root, CriteriaQuery<?> criteriaQuery, CriteriaBuilder criteriaBuilder) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (String processDef : this.processDefinitions) {
            Predicate processDefinitionMatchPredicate = criteriaBuilder.like((Expression)root.get("processDefinitionId"), processDef + "%");
            Path replacedServiceName = root.get("serviceName");
            replacedServiceName = criteriaBuilder.function("REPLACE", String.class, new Expression[]{replacedServiceName, criteriaBuilder.literal((Object)"-"), criteriaBuilder.literal((Object)"")});
            Predicate appNameMatchPredicate = criteriaBuilder.equal(criteriaBuilder.upper((Expression)replacedServiceName), (Object)this.serviceName.replace("-", "").toUpperCase());
            Predicate appRestrictionPredicate = criteriaBuilder.and((Expression)processDefinitionMatchPredicate, (Expression)appNameMatchPredicate);
            predicates.add(appRestrictionPredicate);
        }
        return criteriaBuilder.or(predicates.toArray(new Predicate[predicates.size()]));
    }
}

