/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.identity.keycloak;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.api.runtime.shared.security.PrincipalGroupsProvider;
import org.activiti.api.runtime.shared.security.PrincipalRolesProvider;
import org.activiti.cloud.services.identity.keycloak.client.KeycloakClient;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakGroup;
import org.activiti.cloud.services.identity.keycloak.model.KeycloakRoleMapping;

public class KeycloakClientPrincipalDetailsProvider
implements PrincipalGroupsProvider,
PrincipalRolesProvider {
    private final KeycloakClient keycloakClient;

    public KeycloakClientPrincipalDetailsProvider(KeycloakClient keycloakClient) {
        this.keycloakClient = keycloakClient;
    }

    public List<String> getGroups(Principal principal) {
        return this.keycloakClient.getUserGroups(this.subjectId(principal)).stream().map(KeycloakGroup::getName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<String> getRoles(Principal principal) {
        return this.keycloakClient.getUserRoleMapping(this.subjectId(principal)).stream().map(KeycloakRoleMapping::getName).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    protected String subjectId(Principal principal) {
        return Optional.of(principal).map(Principal::getName).orElseThrow(this::securityException);
    }

    protected SecurityException securityException() {
        return new SecurityException("Invalid Keycloak principal subject id");
    }
}

