/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.common.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.util.StreamUtils;
import org.springframework.web.multipart.MultipartFile;

public class ZipStream {
    private final InputStream inputStream;

    public ZipStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void forEach(Consumer<ZipStreamEntry> consumer) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(this.inputStream);){
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                consumer.accept(new ZipStreamEntry(this, zipEntry, zipInputStream));
            }
        }
    }

    public static ZipStream of(MultipartFile multipartFile) throws IOException {
        return new ZipStream(multipartFile.getInputStream());
    }

    public static ZipStream of(InputStream inputStream) throws IOException {
        return new ZipStream(inputStream);
    }

    public class ZipStreamEntry {
        private final ZipEntry zipEntry;
        private final Optional<byte[]> content;
        private final Path path;
        private final boolean isDirectory;

        ZipStreamEntry(ZipStream this$0, ZipEntry zipEntry, ZipInputStream zipInputStream) throws IOException {
            Objects.requireNonNull(this$0);
            this.zipEntry = zipEntry;
            this.isDirectory = zipEntry.isDirectory();
            this.content = !this.isDirectory ? Optional.of(StreamUtils.copyToByteArray((InputStream)zipInputStream)) : Optional.empty();
            this.path = Paths.get(zipEntry.getName(), new String[0]);
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public Optional<String> getFolderName(int index) {
            int foldersCount;
            Path folderPath = null;
            int n = foldersCount = this.isDirectory ? this.path.getNameCount() : this.path.getNameCount() - 1;
            if (0 <= index && index < foldersCount) {
                folderPath = this.path.getName(index);
            }
            return Optional.ofNullable(folderPath).map(Path::toString);
        }

        public String getFileName() {
            return this.path.getFileName().toString();
        }

        public Optional<byte[]> getContent() {
            return this.content;
        }

        public boolean isDirectory() {
            return this.isDirectory;
        }

        public boolean isAtRoot() {
            return this.path.getNameCount() == 1;
        }
    }
}

