/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.alfresco.converter.json;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.cloud.alfresco.converter.json.PageMetadataConverter;
import org.activiti.cloud.alfresco.rest.model.EntryResponseContent;
import org.activiti.cloud.alfresco.rest.model.ListResponseContent;
import org.activiti.cloud.alfresco.rest.model.PaginationMetadata;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.PagedModel;

public class PagedModelConverter {
    private PageMetadataConverter pageMetadataConverter;

    public PagedModelConverter(PageMetadataConverter pageMetadataConverter) {
        this.pageMetadataConverter = pageMetadataConverter;
    }

    public <T> ListResponseContent<T> pagedCollectionModelToListResponseContent(PagedModel<EntityModel<T>> pagedCollectionModel) {
        List<EntryResponseContent<T>> baseContent = this.getAlfrescoContentEntries((CollectionModel<EntityModel<T>>)pagedCollectionModel);
        PaginationMetadata pagination = this.pageMetadataConverter.toAlfrescoPageMetadata(pagedCollectionModel.getMetadata(), baseContent.size());
        return ListResponseContent.wrap(baseContent, pagination);
    }

    public <T> ListResponseContent<T> resourcesToListResponseContent(CollectionModel<EntityModel<T>> resources) {
        return ListResponseContent.wrap(this.getAlfrescoContentEntries(resources), null);
    }

    private <T> List<EntryResponseContent<T>> getAlfrescoContentEntries(CollectionModel<EntityModel<T>> pagedCollectionModel) {
        Collection pagedResourceContent = pagedCollectionModel.getContent();
        return pagedResourceContent.stream().map(resource -> new EntryResponseContent<Object>(resource.getContent())).collect(Collectors.toList());
    }
}

