/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.listeners;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.configuration.RuntimeBundleProperties;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandContextCloseListener;
import org.springframework.messaging.Message;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Transactional
public class MessageProducerCommandContextCloseListener
implements CommandContextCloseListener {
    public static final String ROOT_EXECUTION_CONTEXT = "rootExecutionContext";
    public static final String PROCESS_ENGINE_EVENTS = "processEngineEvents";
    private final ProcessEngineChannels producer;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final int chunkSize;

    public MessageProducerCommandContextCloseListener(ProcessEngineChannels producer, MessageBuilderChainFactory<ExecutionContext> messageBuilderChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender, RuntimeBundleProperties properties) {
        Assert.notNull((Object)producer, (String)"producer must not be null");
        Assert.notNull(messageBuilderChainFactory, (String)"messageBuilderChainFactory must not be null");
        Assert.notNull((Object)runtimeBundleInfoAppender, (String)"runtimeBundleInfoAppender must not be null");
        this.producer = producer;
        this.messageBuilderChainFactory = messageBuilderChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.chunkSize = properties.getEventsProperties().getChunkSize();
    }

    public void closed(CommandContext commandContext) {
        List events = (List)commandContext.getGenericAttribute(PROCESS_ENGINE_EVENTS);
        if (CollectionUtils.isEmpty((Collection)events)) {
            return;
        }
        ExecutionContext rootExecutionContext = (ExecutionContext)commandContext.getGenericAttribute(ROOT_EXECUTION_CONTEXT);
        this.sendEvents(events, rootExecutionContext);
    }

    private void sendEvents(List<CloudRuntimeEvent<?, ?>> events, ExecutionContext rootExecutionContext) {
        if (CollectionUtils.isEmpty(events)) {
            return;
        }
        Collection<List<CloudRuntimeEventImpl<?, ?>>> eventChunks = this.createEventChunks(events);
        eventChunks.forEach(chunk -> {
            CloudRuntimeEvent[] eventArray = (CloudRuntimeEvent[])chunk.toArray(CloudRuntimeEvent[]::new);
            this.createMessageAndSend(rootExecutionContext, eventArray);
        });
    }

    private Collection<List<CloudRuntimeEventImpl<?, ?>>> createEventChunks(List<CloudRuntimeEvent<?, ?>> events) {
        AtomicInteger chunkIndex = new AtomicInteger();
        return events.stream().filter(CloudRuntimeEventImpl.class::isInstance).map(CloudRuntimeEventImpl.class::cast).map(this.runtimeBundleInfoAppender::appendRuntimeBundleInfoTo).collect(Collectors.groupingBy(event -> chunkIndex.getAndIncrement() / this.chunkSize)).values();
    }

    private void createMessageAndSend(ExecutionContext rootExecutionContext, CloudRuntimeEvent<?, ?>[] items) {
        Message message = this.messageBuilderChainFactory.create(rootExecutionContext).withPayload(items).build();
        this.producer.auditProducer().send(message);
    }

    public void closing(CommandContext commandContext) {
    }

    public void afterSessionsFlush(CommandContext commandContext) {
    }

    public void closeFailure(CommandContext commandContext) {
    }
}

