/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.message;

import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.services.events.message.RoutingKeyResolver;

public abstract class AbstractMessageHeadersRoutingKeyResolver
implements RoutingKeyResolver<Map<String, Object>> {
    private static final String REPLACEMENT = "-";
    private static final String ILLEGAL_CHARACTERS = "[\\t\\s\\.*#:]";
    private static final String DELIMITER = ".";
    private static final String UNDERSCORE = "_";

    @Override
    public abstract String resolve(Map<String, Object> var1);

    protected String build(Map<String, Object> headers, String ... keys) {
        return this.getPrefix() + DELIMITER + Stream.of(keys).map(headers::get).map(Optional::ofNullable).map(this::mapNullOrEmptyValue).collect(Collectors.joining(DELIMITER));
    }

    private String mapNullOrEmptyValue(Optional<Object> obj) {
        return obj.map(Object::toString).filter(value -> !value.isEmpty()).map(this::escapeIllegalCharacters).orElse(UNDERSCORE);
    }

    protected String escapeIllegalCharacters(String value) {
        return value.replaceAll(ILLEGAL_CHARACTERS, REPLACEMENT);
    }

    public abstract String getPrefix();
}

