/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.configuration;

import jakarta.validation.Valid;
import jakarta.validation.constraints.Positive;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@AutoConfiguration
@ConfigurationProperties(prefix="activiti.cloud.runtime-bundle")
@Validated
public class RuntimeBundleProperties {
    @Value(value="${spring.application.name}")
    private String rbSpringAppName;
    @Value(value="${activiti.cloud.service.type:}")
    private String serviceType;
    @Value(value="${activiti.cloud.service.version:}")
    private String serviceVersion;
    @Value(value="${activiti.cloud.application.name:}")
    private String appName;
    private RuntimeBundleMessagingProperties messaging;
    @Valid
    private RuntimeBundleEventsProperties eventsProperties = new RuntimeBundleEventsProperties();

    public String getRbSpringAppName() {
        return this.rbSpringAppName;
    }

    public String getServiceFullName() {
        return this.rbSpringAppName;
    }

    public String getServiceName() {
        return this.getRbSpringAppName();
    }

    public void setRbSpringAppName(String name) {
        this.rbSpringAppName = name;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public RuntimeBundleEventsProperties getEventsProperties() {
        return this.eventsProperties;
    }

    public void setEventsProperties(RuntimeBundleEventsProperties eventsProperties) {
        this.eventsProperties = eventsProperties;
    }

    public RuntimeBundleMessagingProperties getMessaging() {
        return this.messaging;
    }

    public void setMessaging(RuntimeBundleMessagingProperties messaging) {
        this.messaging = messaging;
    }

    public static class RuntimeBundleEventsProperties {
        private boolean integrationAuditEventsEnabled = true;
        @Positive
        private int chunkSize = 100;

        public boolean isIntegrationAuditEventsEnabled() {
            return this.integrationAuditEventsEnabled;
        }

        public void setIntegrationAuditEventsEnabled(boolean integrationAuditEventsEnabled) {
            this.integrationAuditEventsEnabled = integrationAuditEventsEnabled;
        }

        public Integer getChunkSize() {
            return this.chunkSize;
        }

        public void setChunkSize(Integer chunkSize) {
            this.chunkSize = chunkSize;
        }
    }

    public static class RuntimeBundleMessagingProperties {
        private String[] requiredAuditProducerGroups;

        public String[] getRequiredAuditProducerGroups() {
            return this.requiredAuditProducerGroups;
        }

        public void setRequiredAuditProducerGroups(String[] requiredAuditProducerGroups) {
            this.requiredAuditProducerGroups = requiredAuditProducerGroups;
        }
    }
}

