/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import java.util.ArrayList;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.IncidentContext;
import org.activiti.cloud.api.process.model.impl.IncidentContextImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIncidentCreatedEventImpl;
import org.activiti.cloud.services.events.converter.ExecutionContextInfoAppender;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.messaging.Message;

class SendIncidentEventCmd
implements Command<Message> {
    private final IntegrationContext integrationContext;
    private final Exception exception;
    private final RuntimeService runtimeService;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;

    SendIncidentEventCmd(IntegrationContext integrationContext, Exception exception, RuntimeService runtimeService, MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender) {
        this.integrationContext = integrationContext;
        this.exception = exception;
        this.runtimeService = runtimeService;
        this.messageBuilderIncidentsChainFactory = messageBuilderIncidentsChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
    }

    public Message execute(CommandContext commandContext) {
        String executionId = this.integrationContext.getExecutionId();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).list().getFirst();
        return this.createAndSendIncidentEvent(new ExecutionContext(execution), this.exception);
    }

    public Message<ArrayList<Object>> createAndSendIncidentEvent(ExecutionContext rootExecutionContext, Exception exception) {
        ArrayList<CloudIncidentCreatedEventImpl> errorEvents = new ArrayList<CloudIncidentCreatedEventImpl>();
        CloudIncidentCreatedEventImpl incident = this.createCloudIncidentCreatedEvent(rootExecutionContext, exception);
        errorEvents.add(incident);
        return this.messageBuilderIncidentsChainFactory.create(rootExecutionContext).withPayload(errorEvents).build();
    }

    private CloudIncidentCreatedEventImpl createCloudIncidentCreatedEvent(ExecutionContext rootExecutionContext, Exception exception) {
        IncidentContextImpl incidentContext = new IncidentContextImpl();
        incidentContext.setProcessInstanceId(rootExecutionContext.getProcessInstance().getId());
        incidentContext.setProcessDefinitionId(rootExecutionContext.getProcessDefinition().getId());
        incidentContext.setActivityId(rootExecutionContext.getProcessInstance().getActivityId());
        incidentContext.setExecutionId(rootExecutionContext.getExecution().getId());
        CloudIncidentCreatedEventImpl incident = new CloudIncidentCreatedEventImpl((Throwable)exception, (IncidentContext)incidentContext);
        this.getExecutionContextInfoAppender(rootExecutionContext).appendExecutionContextInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        this.runtimeBundleInfoAppender.appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        return incident;
    }

    private ExecutionContextInfoAppender getExecutionContextInfoAppender(ExecutionContext rootExecutionContext) {
        return new ExecutionContextInfoAppender(rootExecutionContext);
    }
}

