/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.cloud.services.events.services.CreateIncidentEventCmd;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.springframework.messaging.Message;

class CreateIncidentEventFromIntegrationCmd
implements CreateIncidentEventCmd {
    private final IntegrationContext integrationContext;
    private final Exception exception;
    private final RuntimeService runtimeService;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;

    CreateIncidentEventFromIntegrationCmd(IntegrationContext integrationContext, Exception exception, RuntimeService runtimeService, MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender) {
        this.integrationContext = integrationContext;
        this.exception = exception;
        this.runtimeService = runtimeService;
        this.messageBuilderIncidentsChainFactory = messageBuilderIncidentsChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
    }

    public Message execute(CommandContext commandContext) {
        String executionId = this.integrationContext.getExecutionId();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(executionId).list().getFirst();
        return this.createAndSendIncidentEvent(new ExecutionContext(execution), this.exception);
    }

    @Override
    public MessageBuilderChainFactory<ExecutionContext> getMessageBuilderIncidentsChainFactory() {
        return this.messageBuilderIncidentsChainFactory;
    }

    @Override
    public RuntimeBundleInfoAppender getRuntimeBundleInfoAppender() {
        return this.runtimeBundleInfoAppender;
    }
}

