/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.services.events.ProcessEngineChannels;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.cloud.services.events.services.CreateIncidentEventFromExecutionCmd;
import org.activiti.cloud.services.events.services.CreateIncidentEventFromIntegrationCmd;
import org.activiti.engine.ManagementService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.Command;
import org.springframework.messaging.Message;

public class IncidentService {
    private final ProcessEngineChannels producer;
    private final MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory;
    private final RuntimeBundleInfoAppender runtimeBundleInfoAppender;
    private final ManagementService managementService;
    private final RuntimeService runtimeService;

    public IncidentService(ProcessEngineChannels producer, MessageBuilderChainFactory<ExecutionContext> messageBuilderIncidentsChainFactory, RuntimeBundleInfoAppender runtimeBundleInfoAppender, ManagementService managementService, RuntimeService runtimeService) {
        this.producer = producer;
        this.messageBuilderIncidentsChainFactory = messageBuilderIncidentsChainFactory;
        this.runtimeBundleInfoAppender = runtimeBundleInfoAppender;
        this.managementService = managementService;
        this.runtimeService = runtimeService;
    }

    public void sendIncidentViaCommand(IntegrationContext integrationContext, Exception exception) {
        Message incidentMessage = (Message)this.managementService.executeCommand((Command)new CreateIncidentEventFromIntegrationCmd(integrationContext, exception, this.runtimeService, this.messageBuilderIncidentsChainFactory, this.runtimeBundleInfoAppender));
        this.producer.auditProducer().send(incidentMessage);
    }

    public void createAndSendIncidentEvent(ExecutionContext rootExecutionContext, Exception exception) {
        Message incidentMessage = (Message)this.managementService.executeCommand((Command)new CreateIncidentEventFromExecutionCmd(rootExecutionContext, exception, this.messageBuilderIncidentsChainFactory, this.runtimeBundleInfoAppender));
        this.producer.auditProducerIncidents().send(incidentMessage);
    }
}

