/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.events.services;

import java.util.ArrayList;
import org.activiti.cloud.api.model.shared.impl.events.CloudRuntimeEventImpl;
import org.activiti.cloud.api.process.model.IncidentContext;
import org.activiti.cloud.api.process.model.impl.IncidentContextImpl;
import org.activiti.cloud.api.process.model.impl.events.CloudIncidentCreatedEventImpl;
import org.activiti.cloud.services.events.converter.ExecutionContextInfoAppender;
import org.activiti.cloud.services.events.converter.RuntimeBundleInfoAppender;
import org.activiti.cloud.services.events.message.MessageBuilderChainFactory;
import org.activiti.engine.impl.context.ExecutionContext;
import org.activiti.engine.impl.interceptor.Command;
import org.springframework.messaging.Message;

interface CreateIncidentEventCmd
extends Command<Message> {
    default public Message<ArrayList<Object>> createMessage(ExecutionContext rootExecutionContext, Exception exception) {
        ArrayList<CloudIncidentCreatedEventImpl> errorEvents = new ArrayList<CloudIncidentCreatedEventImpl>();
        CloudIncidentCreatedEventImpl incident = this.createCloudIncidentCreatedEvent(rootExecutionContext, exception);
        errorEvents.add(incident);
        return this.getMessageBuilderIncidentsChainFactory().create(rootExecutionContext).withPayload(errorEvents).build();
    }

    private CloudIncidentCreatedEventImpl createCloudIncidentCreatedEvent(ExecutionContext rootExecutionContext, Exception exception) {
        IncidentContextImpl incidentContext = this.getIncidentContext(rootExecutionContext);
        CloudIncidentCreatedEventImpl incident = new CloudIncidentCreatedEventImpl((Throwable)exception, (IncidentContext)incidentContext);
        this.getExecutionContextInfoAppender(rootExecutionContext).appendExecutionContextInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        this.getRuntimeBundleInfoAppender().appendRuntimeBundleInfoTo((CloudRuntimeEventImpl<?, ?>)incident);
        return incident;
    }

    private IncidentContextImpl getIncidentContext(ExecutionContext rootExecutionContext) {
        IncidentContextImpl incidentContext = new IncidentContextImpl();
        incidentContext.setProcessInstanceId(rootExecutionContext.getProcessInstance().getId());
        incidentContext.setProcessDefinitionId(rootExecutionContext.getProcessDefinition().getId());
        incidentContext.setActivityId(rootExecutionContext.getProcessInstance().getActivityId());
        incidentContext.setExecutionId(rootExecutionContext.getExecution().getId());
        return incidentContext;
    }

    private ExecutionContextInfoAppender getExecutionContextInfoAppender(ExecutionContext rootExecutionContext) {
        return new ExecutionContextInfoAppender(rootExecutionContext);
    }

    public MessageBuilderChainFactory<ExecutionContext> getMessageBuilderIncidentsChainFactory();

    public RuntimeBundleInfoAppender getRuntimeBundleInfoAppender();
}

