/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.graphql.jpa.query;

import com.introproventures.graphql.jpa.query.autoconfigure.EnableGraphQLJpaQuerySchema;
import com.introproventures.graphql.jpa.query.autoconfigure.GraphQLJPASchemaBuilderCustomizer;
import com.introproventures.graphql.jpa.query.schema.JavaScalars;
import com.introproventures.graphql.jpa.query.schema.RestrictedKeysProvider;
import com.introproventures.graphql.jpa.query.schema.impl.GraphQLJpaSchemaBuilder;
import graphql.GraphQL;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.activiti.cloud.services.notifications.graphql.jpa.query.ActivitiGraphQlFieldVisibilityProvider;
import org.activiti.cloud.services.notifications.graphql.jpa.query.ActivitiGraphQlJPASchemaProperties;
import org.activiti.cloud.services.query.model.ProcessInstanceEntity;
import org.activiti.cloud.services.query.model.VariableValue;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@AutoConfiguration
@ConditionalOnClass(value={GraphQL.class, ProcessInstanceEntity.class})
@ConditionalOnProperty(name={"spring.activiti.cloud.services.notifications.graphql.jpa-query.enabled"}, matchIfMissing=true)
@EnableGraphQLJpaQuerySchema(basePackageClasses={ProcessInstanceEntity.class})
@EnableConfigurationProperties(value={ActivitiGraphQlJPASchemaProperties.class})
@PropertySource(value={"classpath:config/jpa-query.properties"})
public class ActivitiGraphQLSchemaAutoConfiguration {
    private final ActivitiGraphQlJPASchemaProperties properties;

    public ActivitiGraphQLSchemaAutoConfiguration(ActivitiGraphQlJPASchemaProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnProperty(value={"spring.activiti.cloud.services.notifications.graphql.jpa-query.fields-visibility.enabled"}, matchIfMissing=true)
    Supplier<GraphqlFieldVisibility> activitiGraphQlFieldVisibilityProvider() {
        return new ActivitiGraphQlFieldVisibilityProvider(this.properties);
    }

    @Bean
    GraphQLJPASchemaBuilderCustomizer graphQLJPASchemaBuilderCustomizer(ObjectProvider<RestrictedKeysProvider> restrictedKeysProvider) {
        return builder -> {
            builder.name("Query").description("Activiti Cloud Query Schema").enableAggregate(this.properties.getAggregate().isEnabled()).scalar(VariableValue.class, GraphQLScalarType.newScalar().name("VariableValue").coercing((Coercing)new JavaScalars.GraphQLObjectCoercing(this){
                {
                    Objects.requireNonNull(this$0);
                }

                public Object serialize(Object input) {
                    return Optional.ofNullable(input).filter(VariableValue.class::isInstance).map(VariableValue.class::cast).map(it -> Optional.ofNullable(it.getValue()).orElse(Optional.empty())).orElseGet(() -> super.serialize(input));
                }
            }).build());
            restrictedKeysProvider.ifAvailable(arg_0 -> ((GraphQLJpaSchemaBuilder)builder).restrictedKeysProvider(arg_0));
            Optional.ofNullable(this.properties.getEntities()).ifPresent(entities -> entities.forEach(entity -> builder.entityPath(entity.getName())));
        };
    }
}

