/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security;

import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthentication;
import org.activiti.cloud.services.notifications.qraphql.ws.security.JWSAuthenticationManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.security.core.Authentication;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;

@Order(value=-2147483550)
public class JWSAuthenticationInterceptorConfigurer
implements WebSocketMessageBrokerConfigurer {
    private static final String GRAPHQL_MESSAGE_TYPE = "graphQLMessageType";
    private static final String CONNECTION_INIT = "connection_init";
    private static final String X_AUTHORIZATION = "X-Authorization";
    private static final String BEARER = "Bearer";
    private List<String> headerValues = Arrays.asList("connection_init");
    private Predicate<SimpMessageHeaderAccessor> messageSelector = new DefaultMessageSelector(this);
    private final JWSAuthenticationManager authenticationManager;

    @Autowired
    public JWSAuthenticationInterceptorConfigurer(JWSAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new ChannelInterceptor(this){
            final /* synthetic */ JWSAuthenticationInterceptorConfigurer this$0;
            {
                JWSAuthenticationInterceptorConfigurer jWSAuthenticationInterceptorConfigurer = this$0;
                Objects.requireNonNull(jWSAuthenticationInterceptorConfigurer);
                this.this$0 = jWSAuthenticationInterceptorConfigurer;
            }

            public Message<?> preSend(Message<?> message, MessageChannel channel) {
                SimpMessageHeaderAccessor accessor = (SimpMessageHeaderAccessor)MessageHeaderAccessor.getAccessor(message, SimpMessageHeaderAccessor.class);
                if (accessor != null && this.this$0.messageSelector.test(accessor)) {
                    Optional.ofNullable(accessor.getHeader(JWSAuthenticationInterceptorConfigurer.X_AUTHORIZATION)).map(String.class::cast).map(header -> header.replace(JWSAuthenticationInterceptorConfigurer.BEARER, "").trim()).ifPresent(bearer -> {
                        JWSAuthentication jwsAuthToken = new JWSAuthentication((String)bearer);
                        Authentication principal = this.this$0.authenticationManager.authenticate(jwsAuthToken);
                        accessor.setUser((Principal)principal);
                    });
                }
                return message;
            }
        }});
    }

    public void setHeaderValues(List<String> headerValues) {
        this.headerValues = headerValues;
    }

    public void setMessageSelector(Predicate<SimpMessageHeaderAccessor> messageSelector) {
        this.messageSelector = messageSelector;
    }

    class DefaultMessageSelector
    implements Predicate<SimpMessageHeaderAccessor> {
        final /* synthetic */ JWSAuthenticationInterceptorConfigurer this$0;

        DefaultMessageSelector(JWSAuthenticationInterceptorConfigurer this$0) {
            JWSAuthenticationInterceptorConfigurer jWSAuthenticationInterceptorConfigurer = this$0;
            Objects.requireNonNull(jWSAuthenticationInterceptorConfigurer);
            this.this$0 = jWSAuthenticationInterceptorConfigurer;
        }

        @Override
        public boolean test(SimpMessageHeaderAccessor accessor) {
            Object value = accessor.getHeader(JWSAuthenticationInterceptorConfigurer.GRAPHQL_MESSAGE_TYPE);
            return this.this$0.headerValues.contains(value);
        }
    }
}

