/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.jwt;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.activiti.cloud.services.common.security.jwt.JwtAccessTokenValidator;
import org.activiti.cloud.services.common.security.jwt.JwtUserInfoUriAuthenticationConverter;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessToken;
import org.activiti.cloud.services.notifications.qraphql.ws.security.tokenverifier.GraphQLAccessTokenVerifier;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public class JwtAccessTokenVerifier
implements GraphQLAccessTokenVerifier {
    private final JwtAccessTokenValidator jwtAccessTokenValidator;
    private final JwtUserInfoUriAuthenticationConverter jwtUserInfoUriAuthenticationConverter;
    private final JwtDecoder jwtDecoder;
    private final Function<Jwt, List<String>> rolesSupplier;

    public JwtAccessTokenVerifier(JwtAccessTokenValidator jwtAccessTokenValidator, JwtUserInfoUriAuthenticationConverter jwtUserInfoUriAuthenticationConverter, JwtDecoder jwtDecoder, Function<Jwt, List<String>> rolesSupplier) {
        this.jwtAccessTokenValidator = jwtAccessTokenValidator;
        this.jwtUserInfoUriAuthenticationConverter = jwtUserInfoUriAuthenticationConverter;
        this.jwtDecoder = jwtDecoder;
        this.rolesSupplier = rolesSupplier;
    }

    @Override
    public GraphQLAccessToken verifyToken(String tokenString) {
        Jwt jwt = this.jwtDecoder.decode(tokenString);
        if (this.jwtAccessTokenValidator.isValid(jwt)) {
            JwtAuthenticationToken accessToken = (JwtAuthenticationToken)this.jwtUserInfoUriAuthenticationConverter.convert(jwt);
            return new GraphQLAccessToken(accessToken.getName(), Set.copyOf((Collection)this.rolesSupplier.apply(jwt)), accessToken);
        }
        throw new BadCredentialsException("Invalid JWT token");
    }
}

