/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.events.handlers;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.activiti.cloud.api.model.shared.events.CloudRuntimeEvent;
import org.activiti.cloud.services.query.events.handlers.QueryEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryEventHandlerContext {
    private static Logger LOGGER = LoggerFactory.getLogger(QueryEventHandlerContext.class);
    private final Map<String, QueryEventHandler> handlers;

    public QueryEventHandlerContext(Set<QueryEventHandler> handlers) {
        this.handlers = handlers.stream().collect(Collectors.toMap(QueryEventHandler::getHandledEvent, Function.identity()));
    }

    public void handle(CloudRuntimeEvent<?, ?> ... events) {
        if (events != null) {
            Stream.of(events).forEach(event -> {
                QueryEventHandler handler = this.handlers.get(event.getEventType().name());
                if (handler != null) {
                    LOGGER.debug("Handling event: " + handler.getHandledEvent());
                    handler.handle((CloudRuntimeEvent<?, ?>)event);
                } else {
                    LOGGER.debug("No handler found for event: " + event.getEventType().name() + ". Ignoring event");
                }
            });
        }
    }

    protected Map<String, QueryEventHandler> getHandlers() {
        return this.handlers;
    }
}

