/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.query.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.persistence.Basic;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.Transient;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.activiti.api.process.model.IntegrationContext;
import org.activiti.cloud.api.process.model.CloudIntegrationContext;
import org.activiti.cloud.services.query.model.ActivitiEntityMetadata;
import org.activiti.cloud.services.query.model.ListOfStackTraceElementsJsonConverter;
import org.activiti.cloud.services.query.model.MapOfStringObjectJsonConverter;
import org.activiti.cloud.services.query.model.ServiceTaskEntity;
import org.activiti.cloud.services.query.model.StringUtils;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.bytecode.enhance.internal.bytebuddy.InlineDirtyCheckerEqualsHelper;
import org.hibernate.bytecode.enhance.internal.tracker.DirtyTracker;
import org.hibernate.bytecode.enhance.internal.tracker.NoopCollectionTracker;
import org.hibernate.bytecode.enhance.internal.tracker.SimpleFieldTracker;
import org.hibernate.bytecode.enhance.spi.CollectionTracker;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.springframework.format.annotation.DateTimeFormat;

@Entity(name="IntegrationContext")
@Table(name="INTEGRATION_CONTEXT", indexes={@Index(name="integration_context_status_idx", columnList="status", unique=false), @Index(name="integration_context_processInstance_idx", columnList="processInstanceId", unique=false)})
@DynamicInsert
@DynamicUpdate
@EnhancementInfo(version="6.5.3.Final")
public class IntegrationContextEntity
extends ActivitiEntityMetadata
implements CloudIntegrationContext,
ManagedEntity,
PersistentAttributeInterceptable,
SelfDirtinessTracker {
    public static final int ERROR_MESSAGE_LENGTH = 255;
    @Id
    String id;
    @Convert(converter=MapOfStringObjectJsonConverter.class)
    @Column(columnDefinition="text", name="inbound_variables")
    @Basic(fetch=FetchType.LAZY)
    Map<String, Object> inBoundVariables;
    @Convert(converter=MapOfStringObjectJsonConverter.class)
    @Column(columnDefinition="text")
    @Basic(fetch=FetchType.LAZY)
    Map<String, Object> outBoundVariables;
    String rootProcessInstanceId;
    String processInstanceId;
    String parentProcessInstanceId;
    String executionId;
    String processDefinitionId;
    String processDefinitionKey;
    Integer processDefinitionVersion;
    String businessKey;
    String clientId;
    String clientName;
    String clientType;
    String connectorType;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date requestDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date resultDate;
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    @Temporal(value=TemporalType.TIMESTAMP)
    Date errorDate;
    String errorCode;
    @Column(length=255)
    String errorMessage;
    String errorClassName;
    @Convert(converter=ListOfStackTraceElementsJsonConverter.class)
    @Column(columnDefinition="text")
    @Basic(fetch=FetchType.LAZY)
    List<StackTraceElement> stackTraceElements;
    @JsonFormat(shape=JsonFormat.Shape.STRING)
    @Enumerated(value=EnumType.STRING)
    CloudIntegrationContext.IntegrationContextStatus status;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY, optional=true)
    @JoinColumns(value={@JoinColumn(name="processInstanceId", referencedColumnName="processInstanceId", insertable=false, updatable=false), @JoinColumn(name="clientId", referencedColumnName="elementId", insertable=false, updatable=false), @JoinColumn(name="executionId", referencedColumnName="executionId", insertable=false, updatable=false)})
    ServiceTaskEntity serviceTask;
    @Transient
    private Boolean ephemeralVariables;
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient boolean $$_hibernate_useTracker;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;
    @Transient
    private transient DirtyTracker $$_hibernate_tracker;

    public IntegrationContextEntity() {
        this.$$_hibernate_write_inBoundVariables(new HashMap());
        this.$$_hibernate_write_outBoundVariables(new HashMap());
        this.$$_hibernate_write_id(UUID.randomUUID().toString());
    }

    public IntegrationContextEntity(String serviceName, String serviceFullName, String serviceVersion, String appName, String appVersion) {
        super(serviceName, serviceFullName, serviceVersion, appName, appVersion);
        this.$$_hibernate_write_inBoundVariables(new HashMap());
        this.$$_hibernate_write_outBoundVariables(new HashMap());
    }

    public String getId() {
        return this.$$_hibernate_read_id();
    }

    public void setId(String id) {
        this.$$_hibernate_write_id(id);
    }

    public String getRootProcessInstanceId() {
        return this.$$_hibernate_read_rootProcessInstanceId();
    }

    public void setRootProcessInstanceId(String rootProcessInstanceId) {
        this.$$_hibernate_write_rootProcessInstanceId(rootProcessInstanceId);
    }

    public String getProcessInstanceId() {
        return this.$$_hibernate_read_processInstanceId();
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.$$_hibernate_write_processInstanceId(processInstanceId);
    }

    public String getProcessDefinitionId() {
        return this.$$_hibernate_read_processDefinitionId();
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.$$_hibernate_write_processDefinitionId(processDefinitionId);
    }

    public String getClientId() {
        return this.$$_hibernate_read_clientId();
    }

    public void setClientId(String clientId) {
        this.$$_hibernate_write_clientId(clientId);
    }

    public String getConnectorType() {
        return this.$$_hibernate_read_connectorType();
    }

    public void setConnectorType(String connectorType) {
        this.$$_hibernate_write_connectorType(connectorType);
    }

    public Map<String, Object> getInBoundVariables() {
        return this.$$_hibernate_read_inBoundVariables();
    }

    public void setInBoundVariables(Map<String, Object> inboundVariables) {
        this.$$_hibernate_write_inBoundVariables(inboundVariables);
    }

    public Map<String, Object> getOutBoundVariables() {
        return this.$$_hibernate_read_outBoundVariables();
    }

    public String getProcessDefinitionKey() {
        return this.$$_hibernate_read_processDefinitionKey();
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.$$_hibernate_write_processDefinitionKey(processDefinitionKey);
    }

    public Integer getProcessDefinitionVersion() {
        return this.$$_hibernate_read_processDefinitionVersion();
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.$$_hibernate_write_processDefinitionVersion(processDefinitionVersion);
    }

    public String getClientName() {
        return this.$$_hibernate_read_clientName();
    }

    public void setClientName(String clientName) {
        this.$$_hibernate_write_clientName(clientName);
    }

    public String getClientType() {
        return this.$$_hibernate_read_clientType();
    }

    public void setClientType(String clientType) {
        this.$$_hibernate_write_clientType(clientType);
    }

    public String getBusinessKey() {
        return this.$$_hibernate_read_businessKey();
    }

    public void setBusinessKey(String businessKey) {
        this.$$_hibernate_write_businessKey(businessKey);
    }

    public String getParentProcessInstanceId() {
        return this.$$_hibernate_read_parentProcessInstanceId();
    }

    public void setParentProcessInstanceId(String parentProcessInstanceId) {
        this.$$_hibernate_write_parentProcessInstanceId(parentProcessInstanceId);
    }

    @Deprecated
    @JsonIgnore
    public Map<String, Object> getInboundVariables() {
        return this.getInboundVariables();
    }

    @Deprecated
    public void setInboundVariables(Map<String, Object> inboundVariables) {
        this.setInBoundVariables(inboundVariables);
    }

    public Date getRequestDate() {
        return this.$$_hibernate_read_requestDate();
    }

    public void setRequestDate(Date requestDate) {
        this.$$_hibernate_write_requestDate(requestDate);
    }

    public Date getResultDate() {
        return this.$$_hibernate_read_resultDate();
    }

    public void setResultDate(Date resultDate) {
        this.$$_hibernate_write_resultDate(resultDate);
    }

    public Date getErrorDate() {
        return this.$$_hibernate_read_errorDate();
    }

    public void setErrorDate(Date errorDate) {
        this.$$_hibernate_write_errorDate(errorDate);
    }

    public String getErrorMessage() {
        return this.$$_hibernate_read_errorMessage();
    }

    public void setErrorMessage(String errorMessage) {
        this.$$_hibernate_write_errorMessage(StringUtils.truncate(errorMessage, 255));
    }

    public String getErrorClassName() {
        return this.$$_hibernate_read_errorClassName();
    }

    public void setErrorClassName(String errorClassName) {
        this.$$_hibernate_write_errorClassName(errorClassName);
    }

    public List<StackTraceElement> getStackTraceElements() {
        return this.$$_hibernate_read_stackTraceElements();
    }

    public void setStackTraceElements(List<StackTraceElement> stackTraceElements) {
        this.$$_hibernate_write_stackTraceElements(stackTraceElements);
    }

    public void setOutBoundVariables(Map<String, Object> outBoundVariables) {
        this.$$_hibernate_write_outBoundVariables(outBoundVariables);
    }

    public String getErrorCode() {
        return this.$$_hibernate_read_errorCode();
    }

    public void setErrorCode(String errorCode) {
        this.$$_hibernate_write_errorCode(errorCode);
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegrationContextEntity other = (IntegrationContextEntity)obj;
        return this.$$_hibernate_read_id() != null && Objects.equals(this.$$_hibernate_read_id(), other.$$_hibernate_read_id());
    }

    public CloudIntegrationContext.IntegrationContextStatus getStatus() {
        return this.$$_hibernate_read_status();
    }

    public void setStatus(CloudIntegrationContext.IntegrationContextStatus status) {
        this.$$_hibernate_write_status(status);
    }

    public ServiceTaskEntity getServiceTask() {
        return this.$$_hibernate_read_serviceTask();
    }

    public void setServiceTask(ServiceTaskEntity serviceTask) {
        this.$$_hibernate_write_serviceTask(serviceTask);
    }

    public String getExecutionId() {
        return this.$$_hibernate_read_executionId();
    }

    public void setExecutionId(String executionId) {
        this.$$_hibernate_write_executionId(executionId);
    }

    public void addOutBoundVariable(String name, Object value) {
        this.$$_hibernate_read_outBoundVariables().put(name, value);
    }

    public void addOutBoundVariables(Map<String, Object> variables) {
        this.$$_hibernate_read_outBoundVariables().putAll(variables);
    }

    public <T> T getInBoundVariable(String name) {
        return Optional.ofNullable(this.$$_hibernate_read_inBoundVariables()).map(it -> this.$$_hibernate_read_inBoundVariables().get(name)).orElse(null);
    }

    public <T> T getInBoundVariable(String name, Class<T> type) {
        return Optional.ofNullable(this.$$_hibernate_read_inBoundVariables()).map(it -> this.$$_hibernate_read_inBoundVariables().get(name)).orElse(null);
    }

    public <T> T getOutBoundVariable(String name) {
        return Optional.ofNullable(this.$$_hibernate_read_outBoundVariables()).map(it -> it.get(name)).orElse(null);
    }

    public <T> T getOutBoundVariable(String name, Class<T> type) {
        return Optional.ofNullable(this.$$_hibernate_read_outBoundVariables()).map(it -> it.get(name)).orElse(null);
    }

    public boolean hasEphemeralVariables() {
        return Boolean.TRUE.equals(this.ephemeralVariables);
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public boolean $$_hibernate_useTracker() {
        return this.$$_hibernate_useTracker;
    }

    public void $$_hibernate_setUseTracker(boolean bl) {
        this.$$_hibernate_useTracker = bl;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public void $$_hibernate_trackChange(String string) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.add(string);
    }

    public String[] $$_hibernate_getDirtyAttributes() {
        String[] stringArray = this;
        stringArray = null;
        stringArray = this.$$_hibernate_tracker == null ? ArrayHelper.EMPTY_STRING_ARRAY : this.$$_hibernate_tracker.get();
        return stringArray;
    }

    public boolean $$_hibernate_hasDirtyAttributes() {
        IntegrationContextEntity integrationContextEntity = this;
        boolean bl = false;
        bl = this.$$_hibernate_tracker != null && !this.$$_hibernate_tracker.isEmpty();
        return bl;
    }

    public void $$_hibernate_clearDirtyAttributes() {
        if (this.$$_hibernate_tracker != null) {
            this.$$_hibernate_tracker.clear();
        }
    }

    public void $$_hibernate_suspendDirtyTracking(boolean bl) {
        if (this.$$_hibernate_tracker == null) {
            this.$$_hibernate_tracker = new SimpleFieldTracker();
        }
        this.$$_hibernate_tracker.suspend(bl);
    }

    public CollectionTracker $$_hibernate_getCollectionTracker() {
        IntegrationContextEntity integrationContextEntity = this;
        integrationContextEntity = null;
        integrationContextEntity = NoopCollectionTracker.INSTANCE;
        return integrationContextEntity;
    }

    @Override
    public String $$_hibernate_read_serviceName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceName", (Object)this.serviceName);
        }
        return this.serviceName;
    }

    @Override
    public void $$_hibernate_write_serviceName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceName())) {
            this.$$_hibernate_trackChange("serviceName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceName", (Object)this.serviceName, (Object)string);
            return;
        }
        this.serviceName = string;
    }

    @Override
    public String $$_hibernate_read_serviceFullName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceFullName", (Object)this.serviceFullName);
        }
        return this.serviceFullName;
    }

    @Override
    public void $$_hibernate_write_serviceFullName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceFullName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceFullName())) {
            this.$$_hibernate_trackChange("serviceFullName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceFullName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceFullName", (Object)this.serviceFullName, (Object)string);
            return;
        }
        this.serviceFullName = string;
    }

    @Override
    public String $$_hibernate_read_serviceVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceVersion", (Object)this.serviceVersion);
        }
        return this.serviceVersion;
    }

    @Override
    public void $$_hibernate_write_serviceVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceVersion())) {
            this.$$_hibernate_trackChange("serviceVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceVersion", (Object)this.serviceVersion, (Object)string);
            return;
        }
        this.serviceVersion = string;
    }

    @Override
    public String $$_hibernate_read_appName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appName", (Object)this.appName);
        }
        return this.appName;
    }

    @Override
    public void $$_hibernate_write_appName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appName", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appName())) {
            this.$$_hibernate_trackChange("appName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appName", (Object)this.appName, (Object)string);
            return;
        }
        this.appName = string;
    }

    @Override
    public String $$_hibernate_read_appVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "appVersion", (Object)this.appVersion);
        }
        return this.appVersion;
    }

    @Override
    public void $$_hibernate_write_appVersion(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"appVersion", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_appVersion())) {
            this.$$_hibernate_trackChange("appVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.appVersion = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "appVersion", (Object)this.appVersion, (Object)string);
            return;
        }
        this.appVersion = string;
    }

    @Override
    public String $$_hibernate_read_serviceType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceType", (Object)this.serviceType);
        }
        return this.serviceType;
    }

    @Override
    public void $$_hibernate_write_serviceType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceType", (Object)string, (Object)((ActivitiEntityMetadata)this).$$_hibernate_read_serviceType())) {
            this.$$_hibernate_trackChange("serviceType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceType", (Object)this.serviceType, (Object)string);
            return;
        }
        this.serviceType = string;
    }

    public String $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)string);
            return;
        }
        this.id = string;
    }

    public Map $$_hibernate_read_inBoundVariables() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.inBoundVariables = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "inBoundVariables", this.inBoundVariables);
        }
        return this.inBoundVariables;
    }

    public void $$_hibernate_write_inBoundVariables(Map map) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"inBoundVariables", (Object)map, this.inBoundVariables)) {
            this.$$_hibernate_trackChange("inBoundVariables");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.inBoundVariables = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "inBoundVariables", this.inBoundVariables, (Object)map);
            return;
        }
        this.inBoundVariables = map;
    }

    public Map $$_hibernate_read_outBoundVariables() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.outBoundVariables = (Map)this.$$_hibernate_getInterceptor().readObject((Object)this, "outBoundVariables", this.outBoundVariables);
        }
        return this.outBoundVariables;
    }

    public void $$_hibernate_write_outBoundVariables(Map map) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"outBoundVariables", (Object)map, this.outBoundVariables)) {
            this.$$_hibernate_trackChange("outBoundVariables");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.outBoundVariables = (Map)this.$$_hibernate_getInterceptor().writeObject((Object)this, "outBoundVariables", this.outBoundVariables, (Object)map);
            return;
        }
        this.outBoundVariables = map;
    }

    public String $$_hibernate_read_rootProcessInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rootProcessInstanceId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "rootProcessInstanceId", (Object)this.rootProcessInstanceId);
        }
        return this.rootProcessInstanceId;
    }

    public void $$_hibernate_write_rootProcessInstanceId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"rootProcessInstanceId", (Object)string, (Object)this.rootProcessInstanceId)) {
            this.$$_hibernate_trackChange("rootProcessInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.rootProcessInstanceId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "rootProcessInstanceId", (Object)this.rootProcessInstanceId, (Object)string);
            return;
        }
        this.rootProcessInstanceId = string;
    }

    public String $$_hibernate_read_processInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processInstanceId", (Object)this.processInstanceId);
        }
        return this.processInstanceId;
    }

    public void $$_hibernate_write_processInstanceId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processInstanceId", (Object)string, (Object)this.processInstanceId)) {
            this.$$_hibernate_trackChange("processInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processInstanceId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processInstanceId", (Object)this.processInstanceId, (Object)string);
            return;
        }
        this.processInstanceId = string;
    }

    public String $$_hibernate_read_parentProcessInstanceId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentProcessInstanceId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "parentProcessInstanceId", (Object)this.parentProcessInstanceId);
        }
        return this.parentProcessInstanceId;
    }

    public void $$_hibernate_write_parentProcessInstanceId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"parentProcessInstanceId", (Object)string, (Object)this.parentProcessInstanceId)) {
            this.$$_hibernate_trackChange("parentProcessInstanceId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.parentProcessInstanceId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "parentProcessInstanceId", (Object)this.parentProcessInstanceId, (Object)string);
            return;
        }
        this.parentProcessInstanceId = string;
    }

    public String $$_hibernate_read_executionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.executionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "executionId", (Object)this.executionId);
        }
        return this.executionId;
    }

    public void $$_hibernate_write_executionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"executionId", (Object)string, (Object)this.executionId)) {
            this.$$_hibernate_trackChange("executionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.executionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "executionId", (Object)this.executionId, (Object)string);
            return;
        }
        this.executionId = string;
    }

    public String $$_hibernate_read_processDefinitionId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId);
        }
        return this.processDefinitionId;
    }

    public void $$_hibernate_write_processDefinitionId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionId", (Object)string, (Object)this.processDefinitionId)) {
            this.$$_hibernate_trackChange("processDefinitionId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionId", (Object)this.processDefinitionId, (Object)string);
            return;
        }
        this.processDefinitionId = string;
    }

    public String $$_hibernate_read_processDefinitionKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey);
        }
        return this.processDefinitionKey;
    }

    public void $$_hibernate_write_processDefinitionKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionKey", (Object)string, (Object)this.processDefinitionKey)) {
            this.$$_hibernate_trackChange("processDefinitionKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionKey", (Object)this.processDefinitionKey, (Object)string);
            return;
        }
        this.processDefinitionKey = string;
    }

    public Integer $$_hibernate_read_processDefinitionVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion);
        }
        return this.processDefinitionVersion;
    }

    public void $$_hibernate_write_processDefinitionVersion(Integer n) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"processDefinitionVersion", (Object)n, (Object)this.processDefinitionVersion)) {
            this.$$_hibernate_trackChange("processDefinitionVersion");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.processDefinitionVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "processDefinitionVersion", (Object)this.processDefinitionVersion, (Object)n);
            return;
        }
        this.processDefinitionVersion = n;
    }

    public String $$_hibernate_read_businessKey() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "businessKey", (Object)this.businessKey);
        }
        return this.businessKey;
    }

    public void $$_hibernate_write_businessKey(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"businessKey", (Object)string, (Object)this.businessKey)) {
            this.$$_hibernate_trackChange("businessKey");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.businessKey = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "businessKey", (Object)this.businessKey, (Object)string);
            return;
        }
        this.businessKey = string;
    }

    public String $$_hibernate_read_clientId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientId", (Object)this.clientId);
        }
        return this.clientId;
    }

    public void $$_hibernate_write_clientId(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientId", (Object)string, (Object)this.clientId)) {
            this.$$_hibernate_trackChange("clientId");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientId", (Object)this.clientId, (Object)string);
            return;
        }
        this.clientId = string;
    }

    public String $$_hibernate_read_clientName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientName", (Object)this.clientName);
        }
        return this.clientName;
    }

    public void $$_hibernate_write_clientName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientName", (Object)string, (Object)this.clientName)) {
            this.$$_hibernate_trackChange("clientName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientName", (Object)this.clientName, (Object)string);
            return;
        }
        this.clientName = string;
    }

    public String $$_hibernate_read_clientType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "clientType", (Object)this.clientType);
        }
        return this.clientType;
    }

    public void $$_hibernate_write_clientType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"clientType", (Object)string, (Object)this.clientType)) {
            this.$$_hibernate_trackChange("clientType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.clientType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "clientType", (Object)this.clientType, (Object)string);
            return;
        }
        this.clientType = string;
    }

    public String $$_hibernate_read_connectorType() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.connectorType = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "connectorType", (Object)this.connectorType);
        }
        return this.connectorType;
    }

    public void $$_hibernate_write_connectorType(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"connectorType", (Object)string, (Object)this.connectorType)) {
            this.$$_hibernate_trackChange("connectorType");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.connectorType = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "connectorType", (Object)this.connectorType, (Object)string);
            return;
        }
        this.connectorType = string;
    }

    public Date $$_hibernate_read_requestDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requestDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "requestDate", (Object)this.requestDate);
        }
        return this.requestDate;
    }

    public void $$_hibernate_write_requestDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"requestDate", (Object)date, (Object)this.requestDate)) {
            this.$$_hibernate_trackChange("requestDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.requestDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "requestDate", (Object)this.requestDate, (Object)date);
            return;
        }
        this.requestDate = date;
    }

    public Date $$_hibernate_read_resultDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resultDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "resultDate", (Object)this.resultDate);
        }
        return this.resultDate;
    }

    public void $$_hibernate_write_resultDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"resultDate", (Object)date, (Object)this.resultDate)) {
            this.$$_hibernate_trackChange("resultDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.resultDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "resultDate", (Object)this.resultDate, (Object)date);
            return;
        }
        this.resultDate = date;
    }

    public Date $$_hibernate_read_errorDate() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorDate = (Date)this.$$_hibernate_getInterceptor().readObject((Object)this, "errorDate", (Object)this.errorDate);
        }
        return this.errorDate;
    }

    public void $$_hibernate_write_errorDate(Date date) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"errorDate", (Object)date, (Object)this.errorDate)) {
            this.$$_hibernate_trackChange("errorDate");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorDate = (Date)this.$$_hibernate_getInterceptor().writeObject((Object)this, "errorDate", (Object)this.errorDate, (Object)date);
            return;
        }
        this.errorDate = date;
    }

    public String $$_hibernate_read_errorCode() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorCode = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "errorCode", (Object)this.errorCode);
        }
        return this.errorCode;
    }

    public void $$_hibernate_write_errorCode(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"errorCode", (Object)string, (Object)this.errorCode)) {
            this.$$_hibernate_trackChange("errorCode");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorCode = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "errorCode", (Object)this.errorCode, (Object)string);
            return;
        }
        this.errorCode = string;
    }

    public String $$_hibernate_read_errorMessage() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorMessage = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "errorMessage", (Object)this.errorMessage);
        }
        return this.errorMessage;
    }

    public void $$_hibernate_write_errorMessage(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"errorMessage", (Object)string, (Object)this.errorMessage)) {
            this.$$_hibernate_trackChange("errorMessage");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorMessage = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "errorMessage", (Object)this.errorMessage, (Object)string);
            return;
        }
        this.errorMessage = string;
    }

    public String $$_hibernate_read_errorClassName() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorClassName = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "errorClassName", (Object)this.errorClassName);
        }
        return this.errorClassName;
    }

    public void $$_hibernate_write_errorClassName(String string) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"errorClassName", (Object)string, (Object)this.errorClassName)) {
            this.$$_hibernate_trackChange("errorClassName");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.errorClassName = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "errorClassName", (Object)this.errorClassName, (Object)string);
            return;
        }
        this.errorClassName = string;
    }

    public List $$_hibernate_read_stackTraceElements() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.stackTraceElements = (List)this.$$_hibernate_getInterceptor().readObject((Object)this, "stackTraceElements", this.stackTraceElements);
        }
        return this.stackTraceElements;
    }

    public void $$_hibernate_write_stackTraceElements(List list) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"stackTraceElements", (Object)list, this.stackTraceElements)) {
            this.$$_hibernate_trackChange("stackTraceElements");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.stackTraceElements = (List)this.$$_hibernate_getInterceptor().writeObject((Object)this, "stackTraceElements", this.stackTraceElements, (Object)list);
            return;
        }
        this.stackTraceElements = list;
    }

    public CloudIntegrationContext.IntegrationContextStatus $$_hibernate_read_status() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (CloudIntegrationContext.IntegrationContextStatus)this.$$_hibernate_getInterceptor().readObject((Object)this, "status", (Object)this.status);
        }
        return this.status;
    }

    public void $$_hibernate_write_status(CloudIntegrationContext.IntegrationContextStatus integrationContextStatus) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"status", (Object)integrationContextStatus, (Object)this.status)) {
            this.$$_hibernate_trackChange("status");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.status = (CloudIntegrationContext.IntegrationContextStatus)this.$$_hibernate_getInterceptor().writeObject((Object)this, "status", (Object)this.status, (Object)integrationContextStatus);
            return;
        }
        this.status = integrationContextStatus;
    }

    public ServiceTaskEntity $$_hibernate_read_serviceTask() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceTask = (ServiceTaskEntity)this.$$_hibernate_getInterceptor().readObject((Object)this, "serviceTask", (Object)this.serviceTask);
        }
        return this.serviceTask;
    }

    public void $$_hibernate_write_serviceTask(ServiceTaskEntity serviceTaskEntity) {
        if (!InlineDirtyCheckerEqualsHelper.areEquals((PersistentAttributeInterceptable)this, (String)"serviceTask", (Object)serviceTaskEntity, (Object)this.serviceTask)) {
            this.$$_hibernate_trackChange("serviceTask");
        }
        if (this.$$_hibernate_getInterceptor() != null) {
            this.serviceTask = (ServiceTaskEntity)this.$$_hibernate_getInterceptor().writeObject((Object)this, "serviceTask", (Object)this.serviceTask, (Object)serviceTaskEntity);
            return;
        }
        this.serviceTask = serviceTaskEntity;
    }

    public static class IdBuilderHelper {
        public static String from(IntegrationContext integrationContext) {
            return integrationContext.getProcessInstanceId() + ":" + integrationContext.getClientId() + ":" + integrationContext.getExecutionId();
        }
    }
}

