/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.cloud.services.security;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Map;
import java.util.Set;
import org.activiti.cloud.services.security.ProcessDefinitionKeyBasedFilter;
import org.activiti.cloud.services.security.ProcessDefinitionRestrictionProperties;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.activiti.core.common.spring.security.policies.conf.SecurityPoliciesProperties;

public class ProcessDefinitionKeyBasedRestrictionBuilder {
    private SecurityPoliciesManager securityPoliciesManager;
    private SecurityPoliciesProperties securityPoliciesProperties;

    public ProcessDefinitionKeyBasedRestrictionBuilder(SecurityPoliciesManager securityPoliciesManager, SecurityPoliciesProperties securityPoliciesProperties) {
        this.securityPoliciesManager = securityPoliciesManager;
        this.securityPoliciesProperties = securityPoliciesProperties;
    }

    private BooleanExpression equalsIgnoringCaseAndHyphen(StringPath propertyPath, String value) {
        return Expressions.stringTemplate((String)"replace({0},'-','')", (Object[])new Object[]{propertyPath}).equalsIgnoreCase(value.replace("-", ""));
    }

    private BooleanExpression buildServiceNameRestriction(String serviceName, StringPath serviceNamePath, StringPath serviceFullNamePath) {
        BooleanExpression appNamePredicate = this.equalsIgnoringCaseAndHyphen(serviceNamePath, serviceName);
        appNamePredicate = appNamePredicate.or((Predicate)this.equalsIgnoringCaseAndHyphen(serviceFullNamePath, serviceName));
        return appNamePredicate;
    }

    public Predicate applyProcessDefinitionKeyFilter(Predicate currentPredicate, SecurityPolicyAccess securityPolicyAccess, ProcessDefinitionKeyBasedFilter filterMetaData) {
        ProcessDefinitionRestrictionProperties restrictionProperties = filterMetaData.getRestrictionProperties();
        Map restrictions = this.securityPoliciesManager.getAllowedKeys(new SecurityPolicyAccess[]{securityPolicyAccess});
        BooleanExpression securityExpression = null;
        for (String appName : restrictions.keySet()) {
            Set defKeys = (Set)restrictions.get(appName);
            securityExpression = this.addProcessDefRestrictionToExpression(restrictionProperties, securityExpression, appName, defKeys);
        }
        if (securityExpression == null && this.securityPoliciesManager.arePoliciesDefined()) {
            return filterMetaData.buildImpossiblePredicate();
        }
        return securityExpression != null ? securityExpression.and(currentPredicate) : currentPredicate;
    }

    private BooleanExpression addProcessDefRestrictionToExpression(ProcessDefinitionRestrictionProperties restrictionProperties, BooleanExpression securityExpression, String appName, Set<String> defKeys) {
        BooleanExpression appNamePredicate;
        BooleanExpression nextExpression = appNamePredicate = this.buildServiceNameRestriction(appName, restrictionProperties.getServiceNamePath(), restrictionProperties.getServiceFullNamePath());
        if (!defKeys.contains(this.securityPoliciesProperties.getWildcard())) {
            nextExpression = restrictionProperties.getProcessDefinitionKeyPath().in(defKeys).and((Predicate)appNamePredicate);
        }
        securityExpression = securityExpression == null ? nextExpression : securityExpression.or((Predicate)nextExpression);
        return securityExpression;
    }
}

